/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Calendar;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractDragonRenderer<T extends AbstractDragonEntity>
extends MobRenderer<T, EntityModel<T>> {
    public static final String DEF_LOC = "textures/entity/dragon/";
    public boolean isChristmas = false;

    public AbstractDragonRenderer(EntityRendererManager manager, EntityModel<T> model, float shadowSize) {
        super(manager, model, shadowSize);
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(5);
        if (calendar.get(2) == 11 && day > 14 && day < 26) {
            this.isChristmas = true;
        }
    }

    public class SleepLayer
    extends ConditionalLayer {
        public SleepLayer(ResourceLocation locIn) {
            super(locIn, AbstractDragonEntity::func_70608_bn);
        }
    }

    public class ConditionalLayer
    extends AbstractLayerRenderer {
        public Predicate<T> conditions;
        public Function<T, ResourceLocation> func;

        public ConditionalLayer(ResourceLocation locIn, Predicate<T> conditions) {
            this.func = e -> locIn;
            this.conditions = conditions;
        }

        public ConditionalLayer(Function<T, ResourceLocation> funcIn, Predicate<T> conditions) {
            this.func = funcIn;
            this.conditions = conditions;
        }

        @Override
        public void render(T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (!this.conditions.test(entity)) {
                return;
            }
            this.func_215333_a(this.func.apply(entity));
            this.func_215332_c().func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public class GlowLayer
    extends AbstractLayerRenderer {
        private Function<T, ResourceLocation> glowLocation;
        private Predicate<T> shouldRender;

        public GlowLayer(Function<T, ResourceLocation> glowLocation) {
            this(glowLocation, e -> true);
        }

        public GlowLayer(Function<T, ResourceLocation> glowLocation, Predicate<T> predicate) {
            this.glowLocation = glowLocation;
            this.shouldRender = predicate;
        }

        @Override
        public void render(T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (!this.shouldRender.test(entity)) {
                return;
            }
            GameRenderer gamerenderer = Minecraft.func_71410_x().field_71460_t;
            int i = entity.func_70070_b();
            int j = i % 65536;
            int k = i / 65536;
            this.func_215333_a(this.glowLocation.apply(entity));
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)1, (int)1);
            GlStateManager.depthMask((!entity.func_82150_aj() ? 1 : 0) != 0);
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)240.0f);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gamerenderer.func_191514_d(true);
            this.func_215332_c().func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            gamerenderer.func_191514_d(false);
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
            this.func_215334_a((Entity)entity);
            GlStateManager.depthMask((boolean)true);
            GlStateManager.disableBlend();
        }
    }

    public abstract class AbstractLayerRenderer
    extends LayerRenderer<T, EntityModel<T>> {
        public AbstractLayerRenderer() {
            super((IEntityRenderer)AbstractDragonRenderer.this);
        }

        public abstract void render(T var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

        public boolean func_177142_b() {
            return false;
        }
    }
}

