/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan.ai.BFlyBodyController;
import WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan.ai.ButterFlyMoveController;
import WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan.ai.ButterflyNavigator;
import WolfShotz.Wyrmroost.content.entities.dragonegg.DragonEggProperties;
import WolfShotz.Wyrmroost.content.entities.multipart.IMultiPartEntity;
import WolfShotz.Wyrmroost.content.entities.multipart.MultiPartEntity;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.registry.WRSounds;
import WolfShotz.Wyrmroost.util.ConfigData;
import WolfShotz.Wyrmroost.util.QuikMaths;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.CommonGoalWrappers;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.ControlledAttackGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.DefendHomeGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.DragonBreedGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.MoveToHomeGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.WaterSitGoal;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import WolfShotz.Wyrmroost.util.io.ContainerBase;
import WolfShotz.Wyrmroost.util.network.NetworkUtils;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class ButterflyLeviathanEntity
extends AbstractDragonEntity
implements IMultiPartEntity {
    public static final DataParameter<Boolean> HAS_CONDUIT = EntityDataManager.func_187226_a(ButterflyLeviathanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Animation CONDUIT_ANIMATION = new Animation(46);
    public static final Animation ROAR_ANIMATION = new Animation(46);
    public static final Animation BITE_ANIMATION = new Animation(20);
    public MultiPartEntity headPart;
    public MultiPartEntity wingLeftPart;
    public MultiPartEntity wingRightPart;
    public MultiPartEntity tail1Part;
    public MultiPartEntity tail2Part;
    public MultiPartEntity tail3Part;
    public RandomWalkingGoal moveGoal;
    public int lightningAttackCooldown;
    private boolean prevUnderWater;

    public ButterflyLeviathanEntity(EntityType<? extends ButterflyLeviathanEntity> blevi, World world) {
        super(blevi, world);
        this.field_70158_ak = ConfigData.disableFrustumCheck;
        this.field_70765_h = new ButterFlyMoveController(this);
        this.field_70138_W = 2.0f;
        this.setImmune(DamageSource.field_180137_b);
    }

    @Override
    protected BodyController func_184650_s() {
        return new BFlyBodyController(this);
    }

    public static void handleSpawning() {
        WREntities.registerBiomeSpawnEntry((EntityType)WREntities.BUTTERFLY_LEVIATHAN.get(), 1, 1, 1, WREntities.getByTypes(BiomeDictionary.Type.OCEAN));
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WREntities.BUTTERFLY_LEVIATHAN.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ButterflyLeviathanEntity::canSpawnHere);
    }

    public static boolean canSpawnHere(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rng) {
        return rng.nextInt(5) == 0 && worldIn.func_180495_p(pos).func_204520_s().func_206884_a(FluidTags.field_206959_a);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ButterflyNavigator((MobEntity)this, worldIn);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    @Override
    protected void func_184651_r() {
        this.field_70911_d = new WaterSitGoal(this);
        this.field_70714_bg.func_75776_a(1, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new ControlledAttackGoal(this, 1.0, true, 3.4, b -> this.func_184609_a(Hand.MAIN_HAND)));
        this.field_70714_bg.func_75776_a(4, (Goal)new DragonBreedGoal(this, false, false));
        this.moveGoal = new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10);
        this.field_70714_bg.func_75776_a(5, (Goal)this.moveGoal);
        this.field_70714_bg.func_75776_a(6, (Goal)CommonGoalWrappers.lookAt(this, 10.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new DefendHomeGoal(this, Entity::func_70090_H));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(5, CommonGoalWrappers.nonTamedTarget(this, LivingEntity.class, false, true, e -> e instanceof PlayerEntity || e instanceof SquidEntity));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.08);
        this.func_110148_a(SWIM_SPEED).func_111128_a(0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(10.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(28.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)this.field_70146_Z.nextInt(2));
        this.field_70180_af.func_187214_a(HAS_CONDUIT, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("variant", this.getVariant());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setVariant(nbt.func_74762_e("variant"));
        this.field_70180_af.func_187227_b(HAS_CONDUIT, this.invHandler.map(i -> i.getStackInSlot(0).func_77973_b() == Items.field_222048_ij).orElse((Object)false));
    }

    public void setHasConduit(boolean flag) {
        if (this.hasConduit() == flag) {
            return;
        }
        this.field_70180_af.func_187227_b(HAS_CONDUIT, (Object)flag);
        if (flag) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.06);
            this.setAnimation(CONDUIT_ANIMATION);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.045);
            this.func_184185_a(SoundEvents.field_206937_aQ, 1.0f, 1.0f);
        }
    }

    public boolean hasConduit() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_CONDUIT);
    }

    @Override
    public void func_70071_h_() {
        boolean underWater = this.isUnderWater();
        if (underWater != this.prevUnderWater) {
            this.onWaterChange(underWater);
        }
        this.prevUnderWater = underWater;
        if (this.lightningAttackCooldown > 0) {
            --this.lightningAttackCooldown;
        }
        if (this.hasConduit()) {
            long i = this.field_70170_p.func_82737_E();
            if (this.field_70170_p.field_72995_K) {
                this.spawnConduitParticles();
            }
            if (i % 40L == 0L) {
                this.applyEffects();
            }
            if (i % 80L == 0L) {
                if (this.field_70146_Z.nextBoolean()) {
                    this.func_184185_a(SoundEvents.field_206934_aN, 2.0f, 1.0f);
                } else {
                    this.func_184185_a(SoundEvents.field_206935_aO, 2.0f, 1.0f);
                }
            }
        }
        if (this.getAnimation() == CONDUIT_ANIMATION) {
            if (this.animationTick == 1) {
                this.func_184185_a((SoundEvent)WRSounds.BFLY_ROAR.get(), 3.0f, 1.0f);
            }
            if (this.animationTick == 15) {
                this.func_184185_a(SoundEvents.field_206938_K, 1.0f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    ((ServerWorld)this.field_70170_p).func_217468_a(new LightningBoltEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, true));
                }
                Vec3d vec3d = this.getConduitPos(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
                for (int i = 0; i < 26; ++i) {
                    double velX = Math.cos(i);
                    double velZ = Math.sin(i);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, vec3d.field_72450_a, vec3d.field_72448_b + 0.8, vec3d.field_72449_c, velX, 0.0, velZ);
                }
            }
        }
        if (this.getAnimation() == ROAR_ANIMATION && !this.field_70170_p.field_72995_K) {
            if (this.animationTick == 1) {
                this.func_184185_a((SoundEvent)WRSounds.BFLY_ROAR.get(), 3.0f, 1.0f);
            }
            if (this.animationTick == 15) {
                this.strikeTarget();
            }
        }
        if (this.getAnimation() == BITE_ANIMATION) {
            this.field_70177_z = this.field_70759_as;
            if (this.animationTick == 1) {
                this.func_184185_a((SoundEvent)WRSounds.BFLY_HURT.get(), 1.0f, 1.0f);
            }
            if (this.animationTick == 10) {
                AxisAlignedBB size = this.func_174813_aQ().func_186664_h(0.3);
                AxisAlignedBB aabb = size.func_191194_a(QuikMaths.calculateYawAngle(this.field_70761_aq, 0.0, size.func_216364_b() * 1.5));
                this.attackInAABB(aabb);
            }
        }
        super.func_70071_h_();
    }

    public void func_213352_e(Vec3d vec3d) {
        float speed = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        if (this.func_70090_H()) {
            speed = (float)this.func_110148_a(SWIM_SPEED).func_111126_e();
        }
        if (this.func_184186_bw() && this.func_82171_bF()) {
            LivingEntity rider = (LivingEntity)this.func_184179_bs();
            this.field_70125_A = rider.field_70125_A * 0.5f;
            this.field_70759_as = rider.field_70759_as;
            this.field_70177_z = MathHelper.func_219800_b((float)this.field_70759_as, (float)this.field_70177_z, (float)8.0f);
            if (this.func_70090_H() && (rider.field_191988_bg != 0.0f || rider.field_70702_br != 0.0f)) {
                float yVel = -MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180))) * (speed * 15.0f);
                if (yVel > 0.0f && !this.isUnderWater() && this.func_213322_ci().field_72448_b < 0.5) {
                    yVel = 0.0f;
                }
                this.func_213293_j(this.func_213322_ci().field_72450_a, yVel, this.func_213322_ci().field_72449_c);
            }
            this.func_70659_e(speed);
            vec3d = new Vec3d((double)rider.field_70702_br, vec3d.field_72448_b, (double)rider.field_191988_bg);
        }
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(vec3d);
        }
    }

    @Override
    public boolean processInteract(PlayerEntity player, Hand hand, ItemStack stack) {
        if (super.processInteract(player, hand, stack)) {
            return true;
        }
        boolean isFoodItem = this.isFoodItem(stack);
        if (!this.func_70909_n() && !this.func_70090_H() && (this.func_70877_b(stack) || isFoodItem)) {
            int chances = isFoodItem ? 3 : 7;
            this.tame(this.func_70681_au().nextInt(chances) == 0, player);
            return true;
        }
        if (this.func_152114_e((LivingEntity)player)) {
            if (player.func_70093_af()) {
                this.setSit(!this.func_70906_o());
                return true;
            }
            if (!this.field_70170_p.field_72995_K && !this.func_70631_g_()) {
                player.func_184220_m((Entity)this);
                this.setSit(false);
            }
            return true;
        }
        return false;
    }

    public void applyEffects() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(25.0).func_72321_a(0.0, (double)this.field_70170_p.func_217301_I(), 0.0);
        List list = this.field_70170_p.func_217357_a(PlayerEntity.class, axisalignedbb);
        if (list.isEmpty()) {
            return;
        }
        for (PlayerEntity player : list) {
            if (!player.func_70026_G() || !this.func_180425_c().func_218141_a((Vec3i)new BlockPos((Entity)player), 18.0)) continue;
            player.func_195064_c(new EffectInstance(Effects.field_205136_C, 260, 0, true, true));
        }
    }

    private void spawnConduitParticles() {
        if (this.field_70146_Z.nextInt(35) != 0) {
            return;
        }
        Vec3d vec3d = this.getConduitPos(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        for (int i = 0; i < 16; ++i) {
            double motionX = QuikMaths.nextPseudoDouble(this.field_70146_Z) * 1.5;
            double motionY = QuikMaths.nextPseudoDouble(this.field_70146_Z);
            double motionZ = QuikMaths.nextPseudoDouble(this.field_70146_Z) * 1.5;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_205167_W, vec3d.field_72450_a, vec3d.field_72448_b + 2.25, vec3d.field_72449_c, motionX, motionY, motionZ);
        }
    }

    public void onWaterChange(boolean underWater) {
        if (underWater) {
            if (this.moveGoal != null) {
                this.moveGoal.func_179479_b(10);
            }
        } else if (this.moveGoal != null) {
            this.moveGoal.func_179479_b(120);
        }
        this.func_213323_x_();
    }

    @Override
    public void performGenericAttack() {
        this.func_184609_a(Hand.MAIN_HAND);
    }

    @Override
    public void performAltAttack(boolean shouldContinue) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.canLightningStrike()) {
            return;
        }
        PlayerEntity rider = this.getControllingPlayer();
        if (rider == null) {
            return;
        }
        RayTraceResult rtr = QuikMaths.rayTrace(this.field_70170_p, rider, 25.0, false);
        if (rtr.func_216346_c() != RayTraceResult.Type.ENTITY) {
            return;
        }
        EntityRayTraceResult ertr = (EntityRayTraceResult)rtr;
        if (!(ertr.func_216348_a() instanceof LivingEntity)) {
            return;
        }
        this.func_70624_b((LivingEntity)ertr.func_216348_a());
        NetworkUtils.sendAnimationPacket(this, ROAR_ANIMATION);
    }

    public void strikeTarget() {
        LivingEntity target = this.func_70638_az();
        if (!this.field_70170_p.field_72995_K) {
            ((ServerWorld)this.field_70170_p).func_217468_a(new LightningBoltEntity(this.field_70170_p, target.field_70165_t, target.field_70163_u, target.field_70161_v, false));
        }
        this.lightningAttackCooldown = 125;
        if (this.getControllingPlayer() != null) {
            this.func_70624_b(null);
        }
    }

    public boolean canLightningStrike() {
        return this.lightningAttackCooldown <= 0 && (this.func_70090_H() || this.field_70170_p.func_72896_J()) && this.hasConduit();
    }

    public void func_184609_a(Hand hand) {
        super.func_184609_a(hand);
        this.setAnimation(BITE_ANIMATION);
    }

    @Override
    public void handleSleep() {
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        float eyeHeight = 3.1f;
        if (this.func_70631_g_()) {
            eyeHeight *= 0.35f;
        }
        return eyeHeight;
    }

    @Override
    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.getAnimation() == CONDUIT_ANIMATION || this.getAnimation() == ROAR_ANIMATION;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.BFLY_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)WRSounds.BFLY_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.BFLY_DEATH.get();
    }

    public int func_70627_aG() {
        return 165;
    }

    @Override
    public MultiPartEntity[] getParts() {
        return new MultiPartEntity[]{this.headPart, this.wingLeftPart, this.wingRightPart, this.tail1Part, this.tail2Part, this.tail3Part};
    }

    @Override
    public void setMountCameraAngles(boolean backView) {
        if (backView) {
            GlStateManager.translated((double)0.0, (double)-1.0, (double)-10.0);
        } else {
            GlStateManager.translated((double)0.0, (double)-1.0, (double)-7.0);
        }
    }

    public Vec3d getConduitPos(Vec3d offset) {
        return QuikMaths.calculateYawAngle(this.field_70761_aq, 0.0, 4.2).func_72441_c(offset.field_72450_a, offset.field_72448_b + (double)this.func_70047_e() + 2.0, offset.field_72449_c);
    }

    public boolean isUnderWater() {
        return this.func_213290_a(FluidTags.field_206959_a, true);
    }

    @Override
    public boolean canFly() {
        return false;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_217346_i((Entity)this);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public Collection<Item> getFoodItems() {
        return WRItems.Tags.MEATS.func_199885_a();
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return Lists.newArrayList((Object[])new Item[]{Items.field_222066_kO, Items.field_203180_bP, Items.field_222067_kP, Items.field_221600_aB, Items.field_221601_aC}).contains(stack.func_77973_b());
    }

    @Override
    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInv, PlayerEntity player) {
        return new ContainerBase.ButterflyContainer(this, playerInv, windowID);
    }

    @Override
    public LazyOptional<ItemStackHandler> createInv() {
        return LazyOptional.of(() -> new ItemStackHandler(1));
    }

    @Override
    public DragonEggProperties createEggProperties() {
        return new DragonEggProperties(0.75f, 1.25f, 40000).setConditions(Entity::func_70090_H);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, CONDUIT_ANIMATION, ROAR_ANIMATION, BITE_ANIMATION};
    }
}

