/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan.render;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonRenderer;
import WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan.ButterflyLeviathanEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan.render.ButterflyLeviathanModel;
import WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan.render.ConduitRenderer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class ButterflyLeviathanRenderer
extends AbstractDragonRenderer<ButterflyLeviathanEntity> {
    public static final ResourceLocation BLUE = ButterflyLeviathanRenderer.resource("butterfly_leviathan.png");
    public static final ResourceLocation PURPLE = ButterflyLeviathanRenderer.resource("butterfly_leviathan_purple.png");
    public static final ResourceLocation ALBINO = ButterflyLeviathanRenderer.resource("butterfly_leviathan_alb.png");
    public static final ResourceLocation GLOW = ButterflyLeviathanRenderer.resource("butterfly_leviathan_activated.png");

    public ButterflyLeviathanRenderer(EntityRendererManager manager) {
        super(manager, new ButterflyLeviathanModel(), 2.0f);
        this.func_177094_a(new AbstractDragonRenderer.GlowLayer(d -> GLOW, ButterflyLeviathanRenderer::shouldRenderConduit));
    }

    public static ResourceLocation resource(String png) {
        return Wyrmroost.rl("textures/entity/dragon/butterflyleviathan/" + png);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(ButterflyLeviathanEntity entity) {
        if (entity.isSpecial()) {
            return ALBINO;
        }
        switch (entity.getVariant()) {
            default: {
                return BLUE;
            }
            case 1: 
        }
        return PURPLE;
    }

    public static boolean shouldRenderConduit(ButterflyLeviathanEntity entity) {
        if (!entity.hasConduit()) {
            return false;
        }
        return entity.getAnimation() != ButterflyLeviathanEntity.CONDUIT_ANIMATION || entity.getAnimationTick() >= 15;
    }

    public void doRender(ButterflyLeviathanEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((MobEntity)entity, x, y, z, entityYaw, partialTicks);
        if (ButterflyLeviathanRenderer.shouldRenderConduit(entity)) {
            Vec3d vec3d = entity.getConduitPos(new Vec3d(x, y, z));
            ConduitRenderer.render(this.field_76990_c.field_78724_e, entity.field_70173_aa, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, partialTicks);
        }
    }
}

