/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan.render;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ConduitRenderer {
    private static final ResourceLocation CAGE_TEXTURE = new ResourceLocation("textures/entity/conduit/cage.png");
    private static final ResourceLocation WIND_TEXTURE = new ResourceLocation("textures/entity/conduit/wind.png");
    private static final ResourceLocation VERTICAL_WIND_TEXTURE = new ResourceLocation("textures/entity/conduit/wind_vertical.png");
    private static final ResourceLocation OPEN_EYE_TEXTURE = new ResourceLocation("textures/entity/conduit/open_eye.png");
    private static final CageModel CAGE = new CageModel();
    private static final EyeModel EYE = new EyeModel();
    private static final WindModel WIND = new WindModel();

    public static void render(TextureManager textureManager, float ticks, double x, double y, double z, float partialTicks) {
        float f = ticks + partialTicks;
        float f2 = MathHelper.func_76126_a((float)(f * 0.1f)) / 2.0f + 0.5f;
        f2 += f2 * f2;
        textureManager.func_110577_a(CAGE_TEXTURE);
        GlStateManager.disableCull();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x), (float)((float)y + 0.3f + f2 * 0.2f), (float)((float)z));
        GlStateManager.rotatef((float)(f * -0.0375f * 57.295776f), (float)0.5f, (float)1.0f, (float)0.5f);
        CAGE.render();
        GlStateManager.popMatrix();
        int j = (int)ticks / 3 % 22;
        WIND.setBoxIndex(j);
        int k = (int)ticks / 66 % 3;
        if (k == 1) {
            textureManager.func_110577_a(VERTICAL_WIND_TEXTURE);
        } else {
            textureManager.func_110577_a(WIND_TEXTURE);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)(y + 0.5), (double)z);
        if (k != 0) {
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        WIND.render();
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)(y + 0.5), (double)z);
        GlStateManager.scalef((float)0.875f, (float)0.875f, (float)0.875f);
        GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        WIND.render();
        GlStateManager.popMatrix();
        ActiveRenderInfo activeRenderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        textureManager.func_110577_a(OPEN_EYE_TEXTURE);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x), (float)((float)y + 0.3f + f2 * 0.2f), (float)((float)z));
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.rotatef((float)(-activeRenderInfo.func_216778_f()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)activeRenderInfo.func_216777_e(), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        EYE.render();
        GlStateManager.popMatrix();
    }

    static class WindModel
    extends Model {
        private final RendererModel[] windBoxes = new RendererModel[22];
        private int boxIndex;

        public WindModel() {
            this.field_78090_t = 64;
            this.field_78089_u = 1024;
            for (int i = 0; i < 22; ++i) {
                this.windBoxes[i] = new RendererModel((Model)this, 0, 32 * i);
                this.windBoxes[i].func_78789_a(-8.0f, -8.0f, -8.0f, 16, 16, 16);
            }
        }

        public void setBoxIndex(int index) {
            this.boxIndex = index;
        }

        public void render() {
            this.windBoxes[this.boxIndex].func_78785_a(0.0625f);
        }
    }

    static class EyeModel
    extends Model {
        private final RendererModel eyeBox;

        public EyeModel() {
            this.field_78090_t = 8;
            this.field_78089_u = 8;
            this.eyeBox = new RendererModel((Model)this, 0, 0);
            this.eyeBox.func_78790_a(-4.0f, -4.0f, 0.0f, 8, 8, 0, 0.01f);
        }

        public void render() {
            this.eyeBox.func_78785_a(0.083333336f);
        }
    }

    static class CageModel
    extends Model {
        private final RendererModel cageBox;

        public CageModel() {
            this.field_78090_t = 32;
            this.field_78089_u = 16;
            this.cageBox = new RendererModel((Model)this, 0, 0);
            this.cageBox.func_78789_a(-4.0f, -4.0f, -4.0f, 8, 8, 8);
        }

        public void render() {
            this.cageBox.func_78785_a(0.0625f);
        }
    }
}

