/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.canariwyvern;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.canariwyvern.goals.CanariAvoidGoal;
import WolfShotz.Wyrmroost.content.entities.dragonegg.DragonEggProperties;
import WolfShotz.Wyrmroost.content.fluids.CausticWaterFluid;
import WolfShotz.Wyrmroost.registry.WRSounds;
import WolfShotz.Wyrmroost.util.entityutils.ai.FlyerMoveController;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.CommonGoalWrappers;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.DefendHomeGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.DragonBreedGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.FlyerFollowOwnerGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.FlyerWanderGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.MoveToHomeGoal;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import WolfShotz.Wyrmroost.util.network.NetworkUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CanariWyvernEntity
extends AbstractDragonEntity {
    public static final Animation FLAP_WINGS_ANIMATION = new Animation(22);
    public static final Animation PREEN_ANIMATION = new Animation(36);
    public static final Animation THREAT_ANIMATION = new Animation(40);
    public static final Animation ATTACK_ANIMATION = new Animation(15);

    public CanariWyvernEntity(EntityType<? extends AbstractDragonEntity> dragon, World world) {
        super(dragon, world);
        this.shouldFlyThreshold = 2;
        this.field_70765_h = new FlyerMoveController(this, true);
        this.field_70749_g = new LookController((MobEntity)this);
        this.shouldFlyThreshold = 1;
        this.setImmune(CausticWaterFluid.CAUSTIC_WATER);
        this.setImmune(DamageSource.field_76376_m);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new FlyerFollowOwnerGoal(this, 7.0, 1.0, 4.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new DragonBreedGoal(this, true, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new CanariAvoidGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new FlyerWanderGoal(this, true));
        this.field_70714_bg.func_75776_a(8, (Goal)CommonGoalWrappers.lookAt(this, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new DefendHomeGoal(this));
        this.field_70715_bh.func_75776_a(5, CommonGoalWrappers.nonTamedTarget(this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]){

            public boolean func_75250_a() {
                return !CanariWyvernEntity.this.func_70631_g_() && super.func_75250_a();
            }
        });
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e).func_111128_a(0.3);
    }

    @Override
    protected BodyController func_184650_s() {
        return new BodyController((MobEntity)this);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)this.func_70681_au().nextInt(5));
        this.field_70180_af.func_187214_a(GENDER, (Object)this.func_70681_au().nextBoolean());
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("variant", this.getVariant());
        nbt.func_74757_a("Gender", this.getGender());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setVariant(nbt.func_74762_e("variant"));
        this.setGender(nbt.func_74767_n("Gender"));
    }

    @Override
    public int getSpecialChances() {
        return 0;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_70608_bn() && !this.isFlying() && !this.isRiding() && this.noActiveAnimation()) {
            if (this.func_70681_au().nextInt(650) == 0) {
                this.setAnimation(FLAP_WINGS_ANIMATION);
            } else if (this.func_70681_au().nextInt(350) == 0) {
                this.setAnimation(PREEN_ANIMATION);
            }
        }
        if (this.getAnimation() == FLAP_WINGS_ANIMATION) {
            if (this.animationTick == 5 || this.animationTick == 12) {
                this.playSound(SoundEvents.field_206944_gn, 0.7f, 2.0f, true);
            }
            if (this.animationTick == 9 && this.func_70681_au().nextInt(25) == 0) {
                this.func_70099_a(new ItemStack((IItemProvider)Items.field_151008_G), 0.5f);
            }
        }
    }

    @Override
    public boolean processInteract(PlayerEntity player, Hand hand, ItemStack stack) {
        if (super.processInteract(player, hand, stack)) {
            return true;
        }
        if (!this.func_70909_n() && this.isFoodItem(stack)) {
            this.eat(stack);
            this.tame(this.func_70681_au().nextInt(5) == 0, player);
            return true;
        }
        if (this.func_152114_e((LivingEntity)player)) {
            if (player.func_70093_af()) {
                this.setSit(!this.func_70906_o());
                return true;
            }
            if (player.func_184188_bt().size() < 3) {
                this.setSit(true);
                this.setFlying(false);
                this.clearAI();
                this.func_184205_a((Entity)player, true);
                return true;
            }
        }
        return false;
    }

    public void func_213352_e(Vec3d vec3d) {
        if (!this.isFlying()) {
            super.func_213352_e(vec3d);
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean should = super.func_70652_k(entity);
        if (should && entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, 200));
        }
        return should;
    }

    protected void func_175544_ck() {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public void func_184609_a(Hand hand) {
        super.func_184609_a(hand);
        NetworkUtils.sendAnimationPacket(this, ATTACK_ANIMATION);
    }

    public boolean func_70067_L() {
        return super.func_70067_L() && !this.isRiding();
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || this.func_184187_bx() != null;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.CANARI_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return (SoundEvent)WRSounds.CANARI_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.CANARI_DEATH.get();
    }

    @Override
    public Collection<Item> getFoodItems() {
        return Lists.newArrayList((Object[])new Item[]{Items.field_222112_pR});
    }

    @Override
    public DragonEggProperties createEggProperties() {
        return new DragonEggProperties(0.25f, 0.35f, 6000).setCustomTexture(Wyrmroost.rl("textures/entity/dragon/canari/egg.png")).setConditions(c -> c.field_70170_p.func_180495_p(c.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_196648_Z);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, SLEEP_ANIMATION, WAKE_ANIMATION, FLAP_WINGS_ANIMATION, PREEN_ANIMATION, THREAT_ANIMATION, ATTACK_ANIMATION};
    }
}

