/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.dfruitdrake;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.dfruitdrake.goals.NonTamedBabyTemptGoal;
import WolfShotz.Wyrmroost.content.entities.dragonegg.DragonEggProperties;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.util.ConfigData;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.CommonGoalWrappers;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.ControlledAttackGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.DragonBreedGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.MoveToHomeGoal;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.Tags;

public class DragonFruitDrakeEntity
extends AbstractDragonEntity
implements IShearable {
    public static final String DATA_SHEAR = "ShearCooldown";
    public static final Animation STAND_ANIMATION = new Animation(15);
    public static final Animation SIT_ANIMATION = new Animation(15);
    public static final Animation BITE_ANIMATION = new Animation(15);
    private int shearCooldownTime;
    private int napTime;

    public DragonFruitDrakeEntity(EntityType<? extends DragonFruitDrakeEntity> dragon, World world) {
        super(dragon, world);
        SLEEP_ANIMATION = new Animation(15);
        WAKE_ANIMATION = new Animation(15);
    }

    public static void handleSpawning() {
        BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE).stream().forEach(b -> b.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry((EntityType)WREntities.DRAGON_FRUIT_DRAKE.get(), 8, 2, 4)));
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WREntities.DRAGON_FRUIT_DRAKE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, (a, b, c, d, e) -> true);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new ControlledAttackGoal(this, 1.1, false, 1.5, AbstractDragonEntity::performGenericAttack));
        this.field_70714_bg.func_75776_a(5, (Goal)new DragonBreedGoal(this, false, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new NonTamedBabyTemptGoal(this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151034_e})));
        this.field_70714_bg.func_75776_a(7, (Goal)CommonGoalWrappers.followOwner(this, 1.2, 12.0f, 3.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)CommonGoalWrappers.followParent(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)CommonGoalWrappers.lookAt(this, 7.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{DragonFruitDrakeEntity.class}));
        this.field_70715_bh.func_75776_a(2, CommonGoalWrappers.nonTamedTarget(this, PlayerEntity.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.232524f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GENDER, (Object)this.func_70681_au().nextBoolean());
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a(DATA_SHEAR, this.shearCooldownTime);
        nbt.func_74757_a("Gender", this.getGender());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.shearCooldownTime = nbt.func_74762_e(DATA_SHEAR);
        this.setGender(nbt.func_74767_n("Gender"));
    }

    @Override
    public void setSit(boolean sitting) {
        if (this.func_70906_o() == sitting) {
            return;
        }
        super.setSit(sitting);
        if (sitting) {
            this.setAnimation(SIT_ANIMATION);
        } else {
            this.setAnimation(STAND_ANIMATION);
        }
    }

    @Override
    public boolean processInteract(PlayerEntity player, Hand hand, ItemStack stack) {
        if (super.processInteract(player, hand, stack)) {
            return true;
        }
        if (!this.func_70909_n() && this.func_70631_g_() && this.isFoodItem(stack)) {
            this.tame(this.func_70681_au().nextInt(5) == 0, player);
            this.eat(stack);
            return true;
        }
        if (this.func_152114_e((LivingEntity)player) && !this.func_70631_g_() && !player.func_70093_af()) {
            this.setSit(false);
            player.func_184220_m((Entity)this);
            return true;
        }
        if (this.func_152114_e((LivingEntity)player) && player.func_70093_af()) {
            this.setSit(!this.func_70906_o());
            return true;
        }
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70031_b(this.func_70638_az() != null);
        if (this.shearCooldownTime > 0) {
            --this.shearCooldownTime;
        }
        if (this.getAnimation() == BITE_ANIMATION && this.animationTick == 7) {
            this.attackInFront(0);
            if (this.getControllingPlayer() != null) {
                AxisAlignedBB aabb = this.func_174813_aQ().func_186662_g(3.0);
                BlockPos.func_218281_b((BlockPos)new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), (BlockPos)new BlockPos(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f)).filter(p -> this.field_70170_p.func_180495_p(p).func_177230_c() instanceof BushBlock).forEach(p -> this.field_70170_p.func_175655_b(p, true));
            }
        }
    }

    public void func_213352_e(Vec3d vec3d) {
        if (this.func_70051_ag()) {
            vec3d.func_216372_d(2.0, 0.0, 2.0);
        }
        if (!this.func_184207_aI()) {
            super.func_213352_e(vec3d);
            return;
        }
        LivingEntity rider = (LivingEntity)this.func_184179_bs();
        if (this.func_184186_bw()) {
            float f = rider.field_191988_bg;
            float s = rider.field_70702_br;
            float speed = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            boolean moving = f != 0.0f || s != 0.0f;
            Vec3d target = new Vec3d((double)s, vec3d.field_72448_b, (double)f);
            this.func_70659_e(speed / 2.0f);
            super.func_213352_e(target);
            if (moving || this.getAnimation() == BITE_ANIMATION) {
                this.field_70126_B = this.field_70177_z = rider.field_70177_z;
                this.field_70125_A = rider.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            }
        }
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return true;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (this.func_70681_au().nextDouble() <= ConfigData.dfdBabyChance) {
            this.func_70873_a(this.getEggProperties().getGrowthTime());
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_82171_bF() {
        return true;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        float size = 1.8f;
        if (this.func_70631_g_()) {
            size = 1.0f;
        }
        if (this.func_70906_o()) {
            size *= 0.75f;
        }
        return size;
    }

    public double func_70042_X() {
        return super.func_70042_X() + 0.1;
    }

    public boolean isShearable(@Nonnull ItemStack item, IWorldReader world, BlockPos pos) {
        return this.shearCooldownTime <= 0;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IWorld world, BlockPos pos, int fortune) {
        this.func_184185_a(SoundEvents.field_187784_dt, 1.0f, 1.0f);
        this.shearCooldownTime = 12000;
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151034_e, 1)});
    }

    @Override
    public void handleSleep() {
        int sleepChance;
        if (this.func_70608_bn() && --this.napTime <= 0 && this.field_70170_p.func_72935_r() && this.func_70681_au().nextInt(375) == 0) {
            this.setSleeping(false);
            return;
        }
        if (this.func_70608_bn() || this.func_70631_g_() && this.field_70170_p.func_72935_r()) {
            return;
        }
        if (--this.sleepCooldown > 0) {
            return;
        }
        if (this.func_70909_n() && !this.func_70906_o()) {
            return;
        }
        if (!this.isIdling()) {
            return;
        }
        int n = sleepChance = this.field_70170_p.func_72935_r() ? 450 : 300;
        if (this.func_70681_au().nextInt(sleepChance) == 0) {
            this.setSleeping(true);
            this.napTime = 150 * this.func_70681_au().nextInt(9);
        }
    }

    @Override
    public void performGenericAttack() {
        this.func_184609_a(Hand.MAIN_HAND);
    }

    public void func_184609_a(Hand hand) {
        super.func_184609_a(hand);
        this.setAnimation(BITE_ANIMATION);
    }

    @Override
    public boolean canFly() {
        return false;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187558_ak;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187562_am;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187560_al;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.5f;
    }

    @Override
    public Collection<Item> getFoodItems() {
        List<Item> foods = Tags.Items.CROPS.func_199885_a().stream().filter(i -> i.getItem() != Items.field_151075_bm).collect(Collectors.toList());
        Collections.addAll(foods, Items.field_151034_e, Items.field_222112_pR);
        return foods;
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151034_e;
    }

    @Override
    public DragonEggProperties createEggProperties() {
        return new DragonEggProperties(0.45f, 0.75f, 9600);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, SLEEP_ANIMATION, WAKE_ANIMATION, STAND_ANIMATION, SIT_ANIMATION};
    }
}

