/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.minutus;

import WolfShotz.Wyrmroost.content.entities.dragon.minutus.goals.BurrowGoal;
import WolfShotz.Wyrmroost.content.entities.dragon.minutus.goals.RunAwayGoal;
import WolfShotz.Wyrmroost.content.entities.dragon.minutus.goals.WalkRandom;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.registry.WRSounds;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.IAnimatedObject;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class MinutusEntity
extends AnimalEntity
implements IAnimatedObject {
    public Animation animation = NO_ANIMATION;
    public int animationTick;
    public static final Animation BITE_ANIMATION = new Animation(10);
    private static final DataParameter<Boolean> BURROWED = EntityDataManager.func_187226_a(MinutusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public MinutusEntity(EntityType<? extends MinutusEntity> minutus, World world) {
        super(minutus, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, new RunAwayGoal<LivingEntity>(this, LivingEntity.class));
        this.field_70714_bg.func_75776_a(3, (Goal)new BurrowGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new WalkRandom(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BURROWED, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("burrowed", this.isBurrowed());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBurrowed(compound.func_74767_n("burrowed"));
    }

    public boolean isBurrowed() {
        return (Boolean)this.field_70180_af.func_187225_a(BURROWED);
    }

    public void setBurrowed(boolean burrow) {
        this.field_70180_af.func_187227_b(BURROWED, (Object)burrow);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isBurrowed()) {
            if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177979_c(1)).func_185904_a() != Material.field_151595_p) {
                this.setBurrowed(false);
            }
            this.attackAbove();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getAnimation() != NO_ANIMATION) {
            ++this.animationTick;
            if (this.animationTick >= this.animation.getDuration()) {
                this.setAnimation(NO_ANIMATION);
            }
        }
    }

    private void attackAbove() {
        Predicate<Entity> predicateFilter = filter -> {
            if (filter instanceof MinutusEntity) {
                return false;
            }
            return filter instanceof FishingBobberEntity || filter instanceof LivingEntity && filter.func_213305_a((Pose)filter.func_213283_Z()).field_220315_a < 0.9f && filter.func_213305_a((Pose)filter.func_213283_Z()).field_220316_b < 0.9f;
        };
        AxisAlignedBB aabb = this.func_174813_aQ().func_72321_a(0.0, 2.0, 0.0).func_72314_b(0.5, 0.0, 0.5);
        List entities = this.field_70170_p.func_175674_a((Entity)this, aabb, predicateFilter);
        if (entities.isEmpty()) {
            return;
        }
        Optional closest = entities.stream().min((entity1, entity2) -> Float.compare(entity1.func_70032_d((Entity)this), entity2.func_70032_d((Entity)this)));
        Entity entity = (Entity)closest.get();
        if (entity instanceof FishingBobberEntity) {
            entity.func_70106_y();
            this.func_213293_j(0.0, 0.8, 0.0);
            this.setBurrowed(false);
        } else {
            if (this.getAnimation() != BITE_ANIMATION) {
                this.setAnimation(BITE_ANIMATION);
            }
            this.func_70652_k(entity);
        }
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (hand != Hand.MAIN_HAND) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            CompoundNBT nbt = new CompoundNBT();
            ItemStack newDrop = new ItemStack((IItemProvider)WRItems.MINUTUS.get());
            nbt.func_74757_a("isalive", true);
            nbt.func_74778_a("entitytype", EntityType.func_200718_a((EntityType)this.func_200600_R()).toString());
            this.setBurrowed(false);
            this.func_189511_e(nbt);
            newDrop.func_77982_d(nbt);
            if (this.func_145818_k_()) {
                newDrop.func_200302_a(this.func_200201_e());
            }
            ItemEntity drop = new ItemEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, newDrop);
            double d0 = player.field_70165_t - this.field_70165_t;
            double d1 = player.field_70163_u - this.field_70163_u;
            double d2 = player.field_70161_v - this.field_70161_v;
            drop.func_213293_j(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
            this.field_70170_p.func_217376_c((Entity)drop);
            this.func_70106_y();
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_76368_d;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.MINUTUS_IDLE.get();
    }

    protected float func_70599_aP() {
        return 0.3f;
    }

    public boolean func_70104_M() {
        return !this.isBurrowed();
    }

    public boolean func_70067_L() {
        return !this.isBurrowed();
    }

    protected void func_82167_n(Entity entityIn) {
        if (!this.isBurrowed()) {
            super.func_82167_n(entityIn);
        }
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.isBurrowed();
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return null;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, BITE_ANIMATION};
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
        this.setAnimationTick(0);
    }
}

