/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.owdrake;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.content.entities.dragonegg.DragonEggProperties;
import WolfShotz.Wyrmroost.content.io.container.OWDrakeInvContainer;
import WolfShotz.Wyrmroost.content.items.DragonArmorItem;
import WolfShotz.Wyrmroost.registry.WRSounds;
import WolfShotz.Wyrmroost.util.QuikMaths;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.CommonGoalWrappers;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.ControlledAttackGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.DefendHomeGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.DragonBreedGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.GrazeGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.MoveToHomeGoal;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import WolfShotz.Wyrmroost.util.network.NetworkUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SaddleItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class OWDrakeEntity
extends AbstractDragonEntity {
    private static final UUID SPRINTING_ID = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    private static final AttributeModifier SPRINTING_SPEED_BOOST = new AttributeModifier(SPRINTING_ID, "Sprinting speed boost", (double)1.15f, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false);
    public static final Animation SIT_ANIMATION = new Animation(15);
    public static final Animation STAND_ANIMATION = new Animation(15);
    public static final Animation GRAZE_ANIMATION = new Animation(35);
    public static final Animation HORN_ATTACK_ANIMATION = new Animation(15);
    public static final Animation ROAR_ANIMATION = new Animation(86);
    public static final Animation TALK_ANIMATION = new Animation(20);
    private static final DataParameter<Boolean> VARIANT_BOOL = EntityDataManager.func_187226_a(OWDrakeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(OWDrakeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> ARMOR = EntityDataManager.func_187226_a(OWDrakeEntity.class, (IDataSerializer)DataSerializers.field_187196_f);

    public OWDrakeEntity(EntityType<? extends OWDrakeEntity> drake, World world) {
        super(drake, world);
        SLEEP_ANIMATION = new Animation(20);
        WAKE_ANIMATION = new Animation(15);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new ControlledAttackGoal(this, 1.0, true, 2.1, d -> NetworkUtils.sendAnimationPacket(d, HORN_ATTACK_ANIMATION)));
        this.field_70714_bg.func_75776_a(6, (Goal)CommonGoalWrappers.followOwner(this, 1.2, 12.0f, 3.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new DragonBreedGoal(this, false, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new GrazeGoal(this, 2, GRAZE_ANIMATION));
        this.field_70714_bg.func_75776_a(9, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)CommonGoalWrappers.lookAt(this, 10.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new DefendHomeGoal(this));
        this.field_70715_bh.func_75776_a(5, CommonGoalWrappers.nonTamedTarget(this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]){

            public boolean func_75250_a() {
                return super.func_75250_a() && !OWDrakeEntity.this.func_70631_g_();
            }
        });
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.20989);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(3.2);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GENDER, (Object)this.func_70681_au().nextBoolean());
        this.field_70180_af.func_187214_a(VARIANT_BOOL, (Object)false);
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(ARMOR, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        nbt.func_74757_a("gender", this.getGender());
        nbt.func_74757_a("variant", this.getDrakeVariant());
        super.func_213281_b(nbt);
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setGender(nbt.func_74767_n("gender"));
        this.setDrakeVariant(nbt.func_74767_n("variant"));
        this.setArmor((Item)this.invHandler.map(i -> i.getStackInSlot(1).func_77973_b()).orElse((Object)Items.field_190931_a));
        this.setSaddled((Boolean)this.invHandler.map(i -> !i.getStackInSlot(0).func_190926_b()).orElse((Object)false));
        if (nbt.func_74764_b("saddled")) {
            this.invHandler.ifPresent(h -> h.setStackInSlot(1, new ItemStack((IItemProvider)Items.field_151141_av, 1)));
        }
    }

    public boolean getDrakeVariant() {
        return (Boolean)this.field_70180_af.func_187225_a(VARIANT_BOOL);
    }

    public void setDrakeVariant(boolean variant) {
        this.field_70180_af.func_187227_b(VARIANT_BOOL, (Object)variant);
    }

    public boolean hasChest() {
        return (Boolean)this.invHandler.map(i -> !i.getStackInSlot(2).func_190926_b()).orElse((Object)false);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean flag) {
        if (flag) {
            this.func_184185_a(SoundEvents.field_187726_cu, 1.0f, 1.0f);
        }
        this.field_70180_af.func_187227_b(SADDLED, (Object)flag);
    }

    public DragonArmorItem getArmor() {
        return (DragonArmorItem)((ItemStack)this.field_70180_af.func_187225_a(ARMOR)).func_77973_b();
    }

    public void setArmor(Item armor) {
        DragonArmorItem.setDragonArmored(this, 1);
        if (!(armor instanceof DragonArmorItem)) {
            armor = null;
        }
        this.field_70180_af.func_187227_b(ARMOR, (Object)new ItemStack((IItemProvider)armor));
        if (armor != null) {
            this.func_184185_a(SoundEvents.field_187702_cm, 1.0f, 1.0f);
        }
    }

    public boolean isArmored() {
        return ((ItemStack)this.field_70180_af.func_187225_a(ARMOR)).func_77973_b() instanceof DragonArmorItem;
    }

    public void func_70031_b(boolean sprinting) {
        if (this.func_70051_ag() == sprinting) {
            return;
        }
        IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        super.func_70031_b(sprinting);
        if (attribute.func_111127_a(SPRINTING_ID) != null) {
            attribute.func_111124_b(SPRINTING_SPEED_BOOST);
        }
        if (sprinting) {
            attribute.func_111121_a(SPRINTING_SPEED_BOOST);
        }
    }

    @Override
    public int getSpecialChances() {
        return 100;
    }

    @Override
    public LazyOptional<ItemStackHandler> createInv() {
        return LazyOptional.of(() -> new ItemStackHandler(19));
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if ((this.func_70638_az() == null || !this.func_70638_az().func_70089_S()) && this.isAngry()) {
                this.setAngry(false);
            }
            this.func_70031_b(this.isAngry());
        }
        if (this.getAnimation() == ROAR_ANIMATION) {
            if (this.getAnimationTick() == 1) {
                this.func_184185_a((SoundEvent)WRSounds.OWDRAKE_ROAR.get(), 2.5f, 1.0f);
            }
            if (this.getAnimationTick() == 15) {
                for (Entity e : this.getEntitiesNearby(5.0)) {
                    if (e instanceof OWDrakeEntity) continue;
                    double angle = (QuikMaths.getAngle(this.field_70165_t, e.field_70165_t, this.field_70161_v, e.field_70161_v) + 90.0) * Math.PI / 180.0;
                    double x = 1.2 * -Math.cos(angle);
                    double z = 1.2 * -Math.sin(angle);
                    e.func_70024_g(x, 0.4, z);
                }
            }
            if (this.getAnimationTick() > 15) {
                for (Entity e : this.getEntitiesNearby(20.0)) {
                    if (!(e instanceof LivingEntity) || e instanceof OWDrakeEntity) continue;
                    ((LivingEntity)e).func_195064_c(new EffectInstance(Effects.field_76421_d, 120));
                }
                if (!this.func_70909_n() && !this.func_184188_bt().isEmpty()) {
                    for (Entity e : this.func_184188_bt()) {
                        e.func_184210_p();
                        e.func_213293_j(QuikMaths.nextPseudoDouble(this.func_70681_au()) * 3.5, 0.8, QuikMaths.nextPseudoDouble(this.func_70681_au()) * 3.5);
                    }
                }
            }
        }
        if (this.getAnimation() == HORN_ATTACK_ANIMATION) {
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            this.field_70126_B = this.field_70177_z;
            if (this.getAnimationTick() == 8) {
                this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 0.5f);
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187596_cD, SoundCategory.AMBIENT, 1.0f, 0.5f, false);
                AxisAlignedBB size = this.func_174813_aQ().func_186664_h(0.2);
                AxisAlignedBB aabb = size.func_191194_a(QuikMaths.calculateYawAngle(this.field_70761_aq, 0.0, size.func_216364_b() * 1.2));
                this.attackInAABB(aabb);
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean processInteract(PlayerEntity player, Hand hand, ItemStack stack) {
        if (super.processInteract(player, hand, stack)) {
            return true;
        }
        if (stack.func_77973_b() instanceof SaddleItem && !this.isSaddled() && !this.func_70631_g_()) {
            this.invHandler.ifPresent(s -> {
                s.setStackInSlot(0, stack);
                this.func_175505_a(player, stack);
            });
            this.setSaddled(true);
            return true;
        }
        if (this.func_152114_e((LivingEntity)player) && player.func_70093_af()) {
            this.setSit(!this.func_70906_o());
            return true;
        }
        if (this.isSaddled() && !this.func_70877_b(stack) && !this.func_70631_g_() && (!this.func_70909_n() && !this.func_70090_H() || this.func_152114_e((LivingEntity)player))) {
            this.setSit(false);
            if (!this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            this.setHomePos(Optional.empty());
            return true;
        }
        if (this.isFoodItem(stack) && this.func_70631_g_() && !this.func_70909_n()) {
            this.tame(this.func_70681_au().nextInt(10) == 0, player);
            this.func_175505_a(player, stack);
            return true;
        }
        return false;
    }

    public void func_213352_e(Vec3d vec3d) {
        if (this.func_184207_aI() && this.func_82171_bF() && this.func_152114_e((LivingEntity)this.func_184179_bs())) {
            LivingEntity rider = (LivingEntity)this.func_184179_bs();
            if (this.func_184186_bw() && this.func_82171_bF()) {
                float f = rider.field_191988_bg;
                float s = rider.field_70702_br;
                float speed = (float)(this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * (rider.func_70051_ag() ? SPRINTING_SPEED_BOOST.func_111164_d() : 1.0));
                boolean moving = f != 0.0f || s != 0.0f;
                Vec3d target = new Vec3d((double)s, vec3d.field_72448_b, (double)f);
                this.func_70031_b(rider.func_70051_ag());
                this.func_70659_e(speed);
                if (rider.field_70703_bu) {
                    this.field_70767_i.func_75660_a();
                }
                super.func_213352_e(target);
                if (moving || this.getAnimation() == HORN_ATTACK_ANIMATION) {
                    this.field_70126_B = this.field_70177_z = rider.field_70177_z;
                    this.field_70125_A = rider.field_70125_A * 0.5f;
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                    this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                }
                return;
            }
        }
        super.func_213352_e(vec3d);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (!this.func_70909_n() && passenger instanceof LivingEntity) {
            int rand = this.func_70681_au().nextInt(100);
            if (passenger instanceof PlayerEntity && rand == 0) {
                this.tame(true, (PlayerEntity)passenger);
            } else if (rand % 20 == 0 && this.getAnimation() != ROAR_ANIMATION && EntityPredicates.field_188444_d.test(passenger)) {
                this.func_70624_b((LivingEntity)passenger);
            }
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Biome biome = worldIn.func_180494_b(new BlockPos((Entity)this));
        Set biomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA);
        if (biomes.contains(biome)) {
            this.setDrakeVariant(true);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void handleSleep() {
        if (!(this.func_70608_bn() || --this.sleepCooldown > 0 || this.field_70170_p.func_72935_r() || this.func_70909_n() && !this.func_70906_o() || this.func_184207_aI() || this.func_70638_az() != null || !this.func_70661_as().func_75500_f() || this.isAngry() || this.func_203005_aq() || this.isFlying() || this.func_70681_au().nextInt(300) != 0)) {
            this.setSleeping(true);
        } else if (this.func_70608_bn() && this.field_70170_p.func_72935_r() && this.func_70681_au().nextInt(150) == 0) {
            this.setSleeping(false);
        }
    }

    public double func_70042_X() {
        return 1.85;
    }

    public boolean func_82171_bF() {
        return this.isSaddled() && this.func_70909_n();
    }

    protected boolean func_184228_n(Entity entityIn) {
        if (!super.func_184228_n(entityIn)) {
            return false;
        }
        if (this.func_70909_n()) {
            return true;
        }
        return this.getAnimation() != HORN_ATTACK_ANIMATION && this.getAnimation() != ROAR_ANIMATION;
    }

    @Override
    public boolean canFly() {
        return false;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance - 2.0f, damageMultiplier);
    }

    public void func_70624_b(@Nullable LivingEntity target) {
        if (target != null && this.func_70638_az() != target) {
            this.setAngry(true);
            if (!this.func_70909_n() && this.getAnimation() != ROAR_ANIMATION) {
                NetworkUtils.sendAnimationPacket(this, ROAR_ANIMATION);
            }
        }
        super.func_70624_b(target);
    }

    public void func_70615_aA() {
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
        if (this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(4.0f);
        }
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        if (this.field_70173_aa % 2 == 0) {
            this.func_184185_a(SoundEvents.field_187566_ao, 0.3f, 1.0f);
        }
        super.func_180429_a(pos, blockIn);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.OWDRAKE_IDLE.get();
    }

    public void func_70642_aH() {
        if (!this.func_70608_bn()) {
            SoundEvent soundevent;
            if (this.noActiveAnimation()) {
                this.setAnimation(TALK_ANIMATION);
            }
            if ((soundevent = this.func_184639_G()) != null) {
                this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
        }
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)WRSounds.OWDRAKE_HURT.get();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.noActiveAnimation()) {
            this.setAnimation(TALK_ANIMATION);
        }
        super.func_184581_c(source);
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.OWDRAKE_DEATH.get();
    }

    @Override
    public void setSit(boolean sitting) {
        if (sitting != this.func_70906_o()) {
            this.setAnimation(sitting ? SIT_ANIMATION : STAND_ANIMATION);
        }
        super.setSit(sitting);
    }

    @Override
    public void performGenericAttack() {
        this.setAnimation(HORN_ATTACK_ANIMATION);
    }

    @Override
    protected boolean func_70610_aX() {
        return super.func_70610_aX();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.func_70906_o() || this.func_70608_bn() ? super.func_213305_a(poseIn).func_220312_a(1.0f, 0.7f) : super.func_213305_a(poseIn);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 2 + this.field_70146_Z.nextInt(3);
    }

    @Override
    public void setMountCameraAngles(boolean backView) {
        if (backView) {
            GlStateManager.translated((double)0.0, (double)-0.5, (double)0.5);
        } else {
            GlStateManager.translated((double)0.0, (double)0.0, (double)-3.0);
        }
    }

    @Override
    public Collection<Item> getFoodItems() {
        return new ArrayList<Item>(Tags.Items.CROPS_WHEAT.func_199885_a());
    }

    @Override
    public DragonEggProperties createEggProperties() {
        return new DragonEggProperties(0.65f, 1.0f, 18000);
    }

    @Override
    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInv, PlayerEntity player) {
        return new OWDrakeInvContainer(this, playerInv, windowID);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, GRAZE_ANIMATION, HORN_ATTACK_ANIMATION, SIT_ANIMATION, STAND_ANIMATION, SLEEP_ANIMATION, WAKE_ANIMATION, ROAR_ANIMATION};
    }
}

