/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.owdrake;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonRenderer;
import WolfShotz.Wyrmroost.content.entities.dragon.owdrake.OWDrakeEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.owdrake.OWDrakeModel;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;

public class OWDrakeRenderer
extends AbstractDragonRenderer<OWDrakeEntity> {
    public static final ResourceLocation DAISY = OWDrakeRenderer.resource("dasy.png");
    public static final ResourceLocation JEB_ = OWDrakeRenderer.resource("jeb.png");
    public static final ResourceLocation SADDLE_LAYER = OWDrakeRenderer.resource("accessories/saddle.png");
    public static final ResourceLocation ARMOR_IRON = OWDrakeRenderer.resource("accessories/armor_iron.png");
    public static final ResourceLocation ARMOR_GOLD = OWDrakeRenderer.resource("accessories/armor_gold.png");
    public static final ResourceLocation ARMOR_DIAMOND = OWDrakeRenderer.resource("accessories/armor_diamond.png");
    public static final ResourceLocation ARMOR_PLATINUM = OWDrakeRenderer.resource("accessories/armor_platinum.png");
    public static final ResourceLocation ARMOR_GEODE_BLUE = OWDrakeRenderer.resource("accessories/armor_geode_blue.png");
    public static final ResourceLocation ARMOR_GEODE_RED = OWDrakeRenderer.resource("accessories/armor_geode_red.png");
    public static final ResourceLocation ARMOR_GEODE_PURPLE = OWDrakeRenderer.resource("accessories/armor_geode_purple.png");

    public OWDrakeRenderer(EntityRendererManager manager) {
        super(manager, new OWDrakeModel(), 1.6f);
        this.func_177094_a((AbstractDragonRenderer)this.new AbstractDragonRenderer.ConditionalLayer(this::getArmorTexture, OWDrakeEntity::isArmored));
        this.func_177094_a((AbstractDragonRenderer)this.new AbstractDragonRenderer.ConditionalLayer(SADDLE_LAYER, OWDrakeEntity::isSaddled));
    }

    public static ResourceLocation resource(String png) {
        return Wyrmroost.rl("textures/entity/dragon/owdrake/" + png);
    }

    private ResourceLocation getArmorTexture(OWDrakeEntity drake) {
        switch (drake.getArmor().getType()) {
            default: {
                return ARMOR_IRON;
            }
            case GOLD: {
                return ARMOR_GOLD;
            }
            case DIAMOND: {
                return ARMOR_DIAMOND;
            }
            case PLATINUM: {
                return ARMOR_PLATINUM;
            }
            case BLUE_GEODE: {
                return ARMOR_GEODE_BLUE;
            }
            case RED_GEODE: {
                return ARMOR_GEODE_RED;
            }
            case PURPLE_GEODE: 
        }
        return ARMOR_GEODE_PURPLE;
    }

    @Nullable
    protected ResourceLocation getEntityTexture(OWDrakeEntity drake) {
        String path;
        if (drake.func_145818_k_()) {
            String name = drake.func_200201_e().func_150261_e();
            if (name.equals("Daisy")) {
                return DAISY;
            }
            if (name.equalsIgnoreCase("Jeb_")) {
                return JEB_;
            }
        }
        String string = drake.func_70631_g_() ? "child" : (path = drake.getGender() ? "male" : "female");
        if (drake.isSpecial()) {
            return OWDrakeRenderer.resource(path + "_spe.png");
        }
        if (drake.getDrakeVariant()) {
            return OWDrakeRenderer.resource(path + "_sav.png");
        }
        return OWDrakeRenderer.resource(path + "_com.png");
    }
}

