/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.rooststalker;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.rooststalker.goals.ScavengeGoal;
import WolfShotz.Wyrmroost.content.entities.dragon.rooststalker.goals.StoleItemFlee;
import WolfShotz.Wyrmroost.content.entities.dragonegg.DragonEggProperties;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.registry.WRSounds;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.CommonGoalWrappers;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.DefendHomeGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.DragonBreedGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.MoveToHomeGoal;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import WolfShotz.Wyrmroost.util.io.ContainerBase;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class RoostStalkerEntity
extends AbstractDragonEntity {
    private static final Predicate<LivingEntity> TARGETS = target -> target instanceof ChickenEntity || target instanceof RabbitEntity || target instanceof TurtleEntity;
    public static final Animation SCAVENGE_ANIMATION = new Animation(35);
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(RoostStalkerEntity.class, (IDataSerializer)DataSerializers.field_187196_f);

    public RoostStalkerEntity(EntityType<? extends RoostStalkerEntity> stalker, World world) {
        super(stalker, world);
        this.field_70138_W = 0.0f;
        SLEEP_ANIMATION = new Animation(15);
        WAKE_ANIMATION = new Animation(15);
        this.setImmune(DamageSource.field_76369_e);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)CommonGoalWrappers.followOwner(this, 1.2f, 8.0f, 2.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new StoleItemFlee(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new DragonBreedGoal(this, false, false));
        this.field_70714_bg.func_75776_a(11, (Goal)new ScavengeGoal(this, 1.1, SCAVENGE_ANIMATION));
        this.field_70714_bg.func_75776_a(12, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(13, (Goal)CommonGoalWrappers.lookAt(this, 5.0f));
        this.field_70714_bg.func_75776_a(14, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new DefendHomeGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(5, CommonGoalWrappers.nonTamedTarget(this, AnimalEntity.class, false, true, TARGETS));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(ITEM, this.invHandler.map(i -> i.getStackInSlot(0)).orElse((Object)ItemStack.field_190927_a));
        ItemStack stack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!stack.func_190926_b()) {
            this.invHandler.ifPresent(i -> {
                this.setItem(stack);
                this.setStackInSlot(0, stack);
                this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            });
        }
    }

    public ItemStack getItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEM);
    }

    public void setItem(ItemStack item) {
        this.field_70180_af.func_187227_b(ITEM, (Object)item);
        if (!item.func_190926_b()) {
            this.func_184185_a(SoundEvents.field_187719_p, 0.5f, 1.0f);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.285);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_110143_aJ() < this.func_110138_aP() && this.func_70681_au().nextInt(400) != 0) {
            return;
        }
        ItemStack stack = this.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return;
        }
        if (this.func_70877_b(stack)) {
            this.eat(stack);
        }
    }

    @Override
    public boolean processInteract(PlayerEntity player, Hand hand, ItemStack stack) {
        if (super.processInteract(player, hand, stack)) {
            return true;
        }
        ItemStack heldItem = this.getStackInSlot(0);
        Item item = stack.func_77973_b();
        if (!this.func_70909_n() && Tags.Items.EGGS.func_199685_a_((Object)item) || item == WRItems.DRAGON_EGG.get()) {
            this.eat(stack);
            if (this.tame(this.field_70146_Z.nextInt(4) == 0, player)) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            }
            return true;
        }
        if (this.func_70909_n() && this.func_152114_e((LivingEntity)player)) {
            if (player.func_70093_af()) {
                this.setSit(!this.func_70906_o());
                return true;
            }
            if (stack.func_190926_b() && heldItem.func_190926_b() && player.func_184188_bt().size() < 3) {
                this.setSit(false);
                this.func_184205_a((Entity)player, true);
                return true;
            }
            if (stack.func_190926_b() || this.canPickUpStack(stack)) {
                this.setItem(stack);
                this.setStackInSlot(0, stack);
                player.func_184611_a(hand, heldItem);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151074_bl;
    }

    @Override
    public int getSpecialChances() {
        return 185;
    }

    @Override
    protected BodyController func_184650_s() {
        return new BodyController((MobEntity)this);
    }

    @Override
    public boolean canFly() {
        return false;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.STALKER_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)WRSounds.STALKER_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.STALKER_DEATH.get();
    }

    @Override
    public Collection<Item> getFoodItems() {
        return WRItems.Tags.MEATS.func_199885_a();
    }

    public boolean canPickUpStack(ItemStack stack) {
        return !(stack.func_77973_b() instanceof BlockItem) && stack.func_77973_b() != Items.field_151074_bl;
    }

    @Override
    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInv, PlayerEntity player) {
        return new ContainerBase.StalkerContainer(this, playerInv, windowID);
    }

    @Override
    public LazyOptional<ItemStackHandler> createInv() {
        return LazyOptional.of(() -> new ItemStackHandler(1));
    }

    @Override
    public DragonEggProperties createEggProperties() {
        return new DragonEggProperties(0.25f, 0.35f, 6000);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, SLEEP_ANIMATION, WAKE_ANIMATION, SCAVENGE_ANIMATION};
    }
}

