/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.rooststalker;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonRenderer;
import WolfShotz.Wyrmroost.content.entities.dragon.rooststalker.RoostStalkerEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.rooststalker.RoostStalkerModel;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RoostStalkerRenderer
extends AbstractDragonRenderer<RoostStalkerEntity> {
    public static final ResourceLocation BODY = RoostStalkerRenderer.resource("body.png");
    public static final ResourceLocation BODY_SPE = RoostStalkerRenderer.resource("body_spe.png");
    public static final ResourceLocation BODY_XMAS = RoostStalkerRenderer.resource("body_christmas.png");
    public static final ResourceLocation BODY_GLOW = RoostStalkerRenderer.resource("body_glow.png");
    public static final ResourceLocation BODY_SPE_GLOW = RoostStalkerRenderer.resource("body_spe_glow.png");
    public static final ResourceLocation SLEEP = RoostStalkerRenderer.resource("sleep.png");
    private final AbstractDragonRenderer.AbstractLayerRenderer ITEM_STACK_RENDERER = new AbstractDragonRenderer.AbstractLayerRenderer(){

        public void render(RoostStalkerEntity stalker, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            ItemStack stack = stalker.getItem();
            if (!stack.func_190926_b()) {
                float i = stalker.func_70631_g_() ? 1.0f : 0.0f;
                GlStateManager.pushMatrix();
                GlStateManager.rotatef((float)(netHeadYaw / 3.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                if (stalker.func_70608_bn() && stalker.getAnimation() != RoostStalkerEntity.WAKE_ANIMATION) {
                    GlStateManager.translatef((float)(-0.5f - i * 2.8f), (float)(-0.6f - i * 1.8f), (float)-1.49f);
                    GlStateManager.rotatef((float)240.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                } else {
                    GlStateManager.translatef((float)0.0f, (float)(-0.5f - i * -0.4f), (float)((stalker.func_70906_o() ? -1.3f : -1.2f) - i * 0.135f));
                    GlStateManager.rotatef((float)(headPitch / (1.7f - i * -1.0f)), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)-0.3f, (float)0.0f);
                }
                if (stalker.func_70631_g_()) {
                    GlStateManager.scalef((float)0.45f, (float)0.45f, (float)0.45f);
                }
                Minecraft.func_71410_x().func_175599_af().func_184392_a(stack, (LivingEntity)stalker, ItemCameraTransforms.TransformType.GROUND, false);
                GlStateManager.popMatrix();
            }
        }
    };

    public RoostStalkerRenderer(EntityRendererManager manager) {
        super(manager, new RoostStalkerModel(), 0.5f);
        this.func_177094_a(this.ITEM_STACK_RENDERER);
        this.func_177094_a(new AbstractDragonRenderer.GlowLayer(stalker -> stalker.isSpecial() ? BODY_SPE_GLOW : BODY_GLOW));
        this.func_177094_a(new AbstractDragonRenderer.SleepLayer(SLEEP));
    }

    @Nullable
    protected ResourceLocation getEntityTexture(RoostStalkerEntity entity) {
        if (this.isChristmas) {
            return BODY_XMAS;
        }
        return entity.isSpecial() ? BODY_SPE : BODY;
    }

    public static ResourceLocation resource(String png) {
        return Wyrmroost.rl("textures/entity/dragon/rooststalker/" + png);
    }
}

