/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.rooststalker.goals;

import WolfShotz.Wyrmroost.content.entities.dragon.rooststalker.RoostStalkerEntity;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.IAnimatedObject;
import WolfShotz.Wyrmroost.util.network.NetworkUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ScavengeGoal
extends MoveToBlockGoal {
    private RoostStalkerEntity dragon;
    private ServerWorld world;
    private Animation animation;
    private IInventory chest;
    private int searchDelay = 20 + new Random().nextInt(40) + 5;

    public ScavengeGoal(RoostStalkerEntity dragon, double speed, Animation animation) {
        super((CreatureEntity)dragon, speed, 16);
        this.dragon = dragon;
        this.world = (ServerWorld)dragon.field_70170_p;
        this.animation = animation;
    }

    public ScavengeGoal(RoostStalkerEntity dragon, double speed) {
        this(dragon, speed, IAnimatedObject.NO_ANIMATION);
    }

    public boolean func_75250_a() {
        return super.func_75250_a() && !this.dragon.func_70909_n() && !this.dragon.func_70608_bn() && this.isHandEmpty((LivingEntity)this.dragon);
    }

    public void func_75249_e() {
        this.chest = ScavengeGoal.getInventoryAtPosition((World)this.world, this.field_179494_b);
        super.func_75249_e();
    }

    public boolean func_75253_b() {
        return super.func_75253_b() && (Boolean)this.dragon.invHandler.map(e -> e.getStackInSlot(0) == ItemStack.field_190927_a).orElse((Object)false) != false && this.chest != null && !this.chest.func_191420_l();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.func_179487_f()) {
            int index;
            ItemStack stack;
            if (!this.isHandEmpty((LivingEntity)this.dragon)) {
                return;
            }
            if (this.dragon.getAnimation() != this.animation) {
                NetworkUtils.sendAnimationPacket(this.dragon, this.animation);
            }
            if (this.chest == null) {
                return;
            }
            if (this.chest instanceof ChestTileEntity && ((ChestTileEntity)this.chest).field_145987_o == 0) {
                this.interactChest(this.chest, true);
            }
            if (!this.chest.func_191420_l() && --this.searchDelay <= 0 && !(stack = this.chest.func_70301_a(index = new Random().nextInt(this.chest.func_70302_i_()))).func_190926_b() && this.dragon.canPickUpStack(stack)) {
                this.chest.func_70304_b(index);
                this.dragon.invHandler.ifPresent(i -> i.setStackInSlot(0, stack));
                this.dragon.setItem(stack);
            }
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.interactChest(this.chest, false);
        this.searchDelay = 20 + new Random().nextInt(40) + 5;
    }

    @Nullable
    public static IInventory getInventoryAtPosition(World worldIn, BlockPos blockpos) {
        TileEntity tileentity;
        IInventory iinventory = null;
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (blockstate.hasTileEntity() && (tileentity = worldIn.func_175625_s(blockpos)) instanceof IInventory && (iinventory = (IInventory)tileentity) instanceof ChestTileEntity && block instanceof ChestBlock) {
            iinventory = ChestBlock.func_220105_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos, (boolean)true);
        }
        return iinventory;
    }

    protected boolean func_179488_a(IWorldReader world, BlockPos pos) {
        return world.func_175625_s(pos) instanceof IInventory;
    }

    private void interactChest(IInventory intentory, boolean open) {
        if (!(intentory instanceof ChestTileEntity)) {
            return;
        }
        ChestTileEntity chest = (ChestTileEntity)intentory;
        chest.field_145987_o = open ? 1 : 0;
        chest.func_145831_w().func_175641_c(chest.func_174877_v(), chest.func_195044_w().func_177230_c(), 1, chest.field_145987_o);
    }

    private boolean isHandEmpty(LivingEntity entity) {
        return entity.func_184582_a(EquipmentSlotType.MAINHAND) == ItemStack.field_190927_a;
    }
}

