/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.sliverglider;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.content.entities.dragonegg.DragonEggProperties;
import WolfShotz.Wyrmroost.registry.WRSounds;
import WolfShotz.Wyrmroost.util.entityutils.ai.FlyerMoveController;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.CommonGoalWrappers;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.DragonBreedGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.FlyerFollowOwnerGoal;
import WolfShotz.Wyrmroost.util.entityutils.ai.goals.FlyerWanderGoal;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SilverGliderEntity
extends AbstractDragonEntity {
    public static final Animation SIT_ANIMATION = new Animation(10);
    public static final Animation STAND_ANIMATION = new Animation(10);
    public int shotDownTimer;

    public SilverGliderEntity(EntityType<? extends SilverGliderEntity> entity, World world) {
        super(entity, world);
        this.field_70765_h = new FlyerMoveController(this, true);
        SLEEP_ANIMATION = new Animation(20);
        WAKE_ANIMATION = new Animation(15);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.257657);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e).func_111128_a(0.366836);
    }

    public static <T extends AbstractDragonEntity> boolean canSpawnHere(EntityType<T> glider, IWorld world, SpawnReason reason, BlockPos blockPos, Random rand) {
        Block block = world.func_180495_p(blockPos.func_177979_c(1)).func_177230_c();
        return block == Blocks.field_150350_a || block == Blocks.field_150354_m || block == Blocks.field_150355_j;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)CommonGoalWrappers.nonTamedTemptGoal(this, 0.6, true, Ingredient.func_199805_a((Tag)ItemTags.field_206964_G)));
        this.field_70714_bg.func_75776_a(5, CommonGoalWrappers.nonTamedAvoidGoal(this, PlayerEntity.class, 16.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new DragonBreedGoal(this, true, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new FlyerFollowOwnerGoal(this, 12.0, 3.0, 15.0, true));
        this.field_70714_bg.func_75776_a(10, (Goal)CommonGoalWrappers.lookAt(this, 10.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new FlyerWanderGoal(this, true){

            @Override
            public Vec3d getPosition() {
                Vec3d vec3d = super.getPosition();
                if (SilverGliderEntity.this.isFlying()) {
                    for (int i = 1; i < 4; ++i) {
                        if (!SilverGliderEntity.this.field_70170_p.func_180495_p(SilverGliderEntity.this.func_180425_c().func_177979_c(i)).func_185904_a().func_76224_d()) continue;
                        return new Vec3d(vec3d.field_72450_a, Math.abs(vec3d.field_72448_b), vec3d.field_72449_c);
                    }
                }
                return vec3d;
            }
        });
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GENDER, (Object)this.func_70681_au().nextBoolean());
        this.field_70180_af.func_187214_a(VARIANT, (Object)this.func_70681_au().nextInt(3));
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("gender", this.getGender());
        nbt.func_74768_a("variant", this.getVariant());
    }

    @Override
    public void setFlying(boolean fly) {
        if (this.isFlying() == fly) {
            return;
        }
        super.setFlying(fly);
    }

    @Override
    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    @Override
    public int getSpecialChances() {
        return 500;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.shouldFlyThreshold = 3 + (this.isRiding() ? 2 : 0);
        if (this.shotDownTimer > 0) {
            --this.shotDownTimer;
        }
    }

    public void func_213352_e(Vec3d vec3d) {
        if (!this.isFlying()) {
            super.func_213352_e(vec3d);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setVariant(nbt.func_74762_e("variant"));
        this.setGender(nbt.func_74767_n("gender"));
    }

    @Override
    public void func_70098_U() {
        PlayerEntity player;
        super.func_70098_U();
        Entity entity = this.func_184187_bx();
        if (entity instanceof PlayerEntity && this.shouldGlide(player = (PlayerEntity)entity) && !player.func_184613_cA()) {
            double d14;
            double d4;
            float f4;
            Vec3d vec3d3 = player.func_213322_ci();
            player.func_213317_d(vec3d3.func_72441_c(0.0, 0.09, 0.0));
            if (vec3d3.field_72448_b > -0.5) {
                player.field_70143_R = 1.0f;
            }
            Vec3d vec3d = player.func_70040_Z();
            float f6 = player.field_70125_A * ((float)Math.PI / 180);
            double d9 = Math.sqrt(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c);
            double d11 = Math.sqrt(SilverGliderEntity.func_213296_b((Vec3d)vec3d3));
            double d12 = vec3d.func_72433_c();
            float f3 = MathHelper.func_76134_b((float)f6);
            f3 = (float)((double)f3 * (double)f3 * Math.min(1.0, d12 / 0.4));
            vec3d3 = player.func_213322_ci().func_72441_c(0.0, 0.08 * (-1.0 + (double)f3 * 0.75), 0.0);
            if (vec3d3.field_72448_b < 0.0 && d9 > 0.0) {
                double d3 = vec3d3.field_72448_b * -0.1 * (double)f3;
                vec3d3 = vec3d3.func_72441_c(vec3d.field_72450_a * d3 / d9, d3, vec3d.field_72449_c * d3 / d9);
            }
            if (f6 < 0.0f && d9 > 0.0) {
                double d13 = d11 * (double)(-MathHelper.func_76126_a((float)f6)) * 0.04;
                vec3d3 = vec3d3.func_72441_c(-vec3d.field_72450_a * d13 / d9, d13 * 3.2, -vec3d.field_72449_c * d13 / d9);
            }
            if (d9 > 0.0) {
                vec3d3 = vec3d3.func_72441_c((vec3d.field_72450_a / d9 * d11 - vec3d3.field_72450_a) * 0.1, 0.0, (vec3d.field_72449_c / d9 * d11 - vec3d3.field_72449_c) * 0.1);
            }
            player.func_213317_d(vec3d3.func_216372_d((double)0.99f, (double)0.98f, (double)0.99f));
            player.func_213315_a(MoverType.SELF, player.func_213322_ci());
            if (player.field_70123_F && !this.field_70170_p.field_72995_K && (f4 = (float)((d4 = d11 - (d14 = Math.sqrt(SilverGliderEntity.func_213296_b((Vec3d)player.func_213322_ci())))) * 10.0 - 3.0)) > 0.0f) {
                this.func_184185_a(this.func_184588_d((int)f4), 1.0f, 1.0f);
                player.func_70097_a(DamageSource.field_188406_j, f4);
                this.func_70097_a(DamageSource.field_188406_j, f4);
            }
        }
    }

    public boolean shouldGlide(PlayerEntity player) {
        return player.field_70703_bu && this.getAltitude(true) > (double)this.shouldFlyThreshold && player.func_184187_bx() == null && !player.field_71075_bZ.field_75100_b && !player.func_70090_H() && super.canFly();
    }

    @Override
    public boolean processInteract(PlayerEntity player, Hand hand, ItemStack stack) {
        if (super.processInteract(player, hand, stack)) {
            return true;
        }
        if (!this.func_70909_n() && this.func_70877_b(stack)) {
            this.tame(this.func_70681_au().nextInt(5) == 0, player);
            this.eat(stack);
            return true;
        }
        if (this.func_70909_n() && stack.func_190926_b() && !player.func_70093_af() && player.func_184188_bt().isEmpty() && this.func_152114_e((LivingEntity)player)) {
            this.func_184205_a((Entity)player, true);
            this.setSit(false);
            this.func_70661_as().func_75499_g();
            return true;
        }
        if (this.func_70909_n() && stack.func_190926_b() && player.func_70093_af() && this.func_152114_e((LivingEntity)player)) {
            this.setSit(!this.func_70906_o());
            return true;
        }
        return false;
    }

    @Override
    public void doSpecialEffects() {
        if (this.field_70173_aa % 5 == 0) {
            double x = this.field_70165_t + this.func_70681_au().nextGaussian();
            double y = this.field_70163_u + this.func_70681_au().nextDouble();
            double z = this.field_70161_v + this.func_70681_au().nextGaussian();
            this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 0.8f, 0.0f, 1.0f), x, y, z, 0.0, (double)0.1925f, 0.0);
        }
    }

    @Override
    public boolean canFly() {
        if (this.shotDownTimer > 0) {
            return false;
        }
        if (this.isRiding() && this.func_184187_bx() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)this.func_184187_bx();
            return super.canFly() && this.shouldGlide(player) || player.func_184613_cA();
        }
        if (this.isRiding()) {
            return false;
        }
        return super.canFly();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.func_70909_n() && source.func_76352_a()) {
            this.shotDownTimer = 12000;
            this.setFlying(false);
        }
        return super.func_70097_a(source, amount);
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.SILVERGLIDER_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return (SoundEvent)WRSounds.SILVERGLIDER_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.SILVERGLIDER_DEATH.get();
    }

    @Override
    public void setSit(boolean sitting) {
        if (sitting != this.func_70906_o()) {
            this.setAnimation(sitting ? SIT_ANIMATION : STAND_ANIMATION);
        }
        super.setSit(sitting);
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || this.func_184187_bx() != null;
    }

    public boolean func_70067_L() {
        return !this.isRiding();
    }

    @Override
    public Collection<Item> getFoodItems() {
        return new ArrayList<Item>(ItemTags.field_206964_G.func_199885_a());
    }

    @Override
    public DragonEggProperties createEggProperties() {
        return new DragonEggProperties(0.4f, 0.65f, 12000);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, SIT_ANIMATION, STAND_ANIMATION, SLEEP_ANIMATION, WAKE_ANIMATION};
    }
}

