/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragon.sliverglider;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonRenderer;
import WolfShotz.Wyrmroost.content.entities.dragon.sliverglider.SilverGliderEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.sliverglider.SilverGliderModel;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;

public class SilverGliderRenderer
extends AbstractDragonRenderer<SilverGliderEntity> {
    public static final ResourceLocation FEMALE = SilverGliderRenderer.resource("female.png");
    public static final ResourceLocation FEMALE_GLOW = SilverGliderRenderer.resource("female_glow.png");
    public static final ResourceLocation BODY_SPE = SilverGliderRenderer.resource("spe.png");
    public static final ResourceLocation BODY_SPE_GLOW = SilverGliderRenderer.resource("spe_glow.png");
    public static final ResourceLocation XMAS_LAYER = SilverGliderRenderer.resource("body_christmas.png");
    public static final ResourceLocation XMAS_GLOW = SilverGliderRenderer.resource("body_christmas_glow.png");
    public static final ResourceLocation SLEEP = SilverGliderRenderer.resource("sleep.png");

    public SilverGliderRenderer(EntityRendererManager manager) {
        super(manager, new SilverGliderModel(), 1.0f);
        this.func_177094_a(new AbstractDragonRenderer.GlowLayer(this::getGlowTexture));
        if (this.isChristmas) {
            this.func_177094_a((AbstractDragonRenderer)this.new AbstractDragonRenderer.ConditionalLayer(XMAS_LAYER, c -> true));
            this.func_177094_a(new AbstractDragonRenderer.GlowLayer(sg -> XMAS_GLOW));
        }
        this.func_177094_a(new AbstractDragonRenderer.SleepLayer(SLEEP));
    }

    public static ResourceLocation resource(String png) {
        return Wyrmroost.rl("textures/entity/dragon/silverglider/" + png);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(SilverGliderEntity sg) {
        if (sg.isSpecial()) {
            return BODY_SPE;
        }
        if (!sg.getGender()) {
            return FEMALE;
        }
        return SilverGliderRenderer.resource("male_" + sg.getVariant() + ".png");
    }

    private ResourceLocation getGlowTexture(SilverGliderEntity sg) {
        if (sg.isSpecial()) {
            return BODY_SPE_GLOW;
        }
        if (!sg.getGender()) {
            return FEMALE_GLOW;
        }
        return SilverGliderRenderer.resource("male_" + sg.getVariant() + "_glow.png");
    }
}

