/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.dragonegg;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.content.entities.dragonegg.DragonEggProperties;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.util.ModUtils;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.IAnimatedObject;
import WolfShotz.Wyrmroost.util.network.NetworkUtils;
import WolfShotz.Wyrmroost.util.network.messages.EggHatchMessage;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class DragonEggEntity
extends Entity
implements IAnimatedObject,
IEntityAdditionalSpawnData {
    public EntityType<AbstractDragonEntity> containedDragon;
    public int hatchTime;
    public DragonEggProperties properties;
    public boolean wiggleInvert;
    public boolean wiggleInvert2;
    private int animationTick;
    private Animation animation = NO_ANIMATION;
    public static final Animation WIGGLE_ANIMATION = new Animation(10);

    public DragonEggEntity(EntityType<? extends DragonEggEntity> dragonEgg, World world) {
        super(dragonEgg, world);
    }

    protected void func_70088_a() {
    }

    public void func_70037_a(CompoundNBT compound) {
        this.containedDragon = ModUtils.getTypeByString(compound.func_74779_i("dragonType"));
        this.hatchTime = compound.func_74762_e("hatchTime");
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("dragonType", this.getDragonKey());
        compound.func_74768_a("hatchTime", this.hatchTime);
    }

    public String getDragonKey() {
        return EntityType.func_200718_a(this.containedDragon).toString();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.containedDragon == null) {
            this.safeError();
            return;
        }
        super.func_70071_h_();
        this.updateMotion();
        if (this.getProperties().getConditions().test(this)) {
            if (this.field_70170_p.field_72995_K) {
                if (this.field_70173_aa % 3 == 0) {
                    double x = this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.2;
                    double y = this.field_70163_u + this.field_70146_Z.nextDouble() + (double)(this.func_213302_cg() / 2.0f);
                    double z = this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.2;
                    this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 1.0f, 0.0f, 0.5f), x, y, z, 0.0, 0.0, 0.0);
                }
            } else {
                if (--this.hatchTime <= 0) {
                    Wyrmroost.NETWORK.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EggHatchMessage(this));
                    this.hatch();
                    return;
                }
                int bounds = Math.max(this.hatchTime / 2, 3);
                if (this.hatchTime < this.getProperties().getHatchTime() / 2 && this.field_70146_Z.nextInt(bounds) == 0 && this.getAnimation() != WIGGLE_ANIMATION) {
                    this.crack(true);
                }
            }
        }
        EntitySize size = this.getProperties().getSize();
        if (this.func_213311_cf() != size.field_220315_a || this.func_213302_cg() != size.field_220316_b) {
            this.func_213323_x_();
        }
        if (this.getAnimation() != NO_ANIMATION) {
            ++this.animationTick;
            if (this.animationTick >= this.animation.getDuration()) {
                this.setAnimation(NO_ANIMATION);
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (distance > 3.0f) {
            this.crack(false);
        }
    }

    private void updateMotion() {
        boolean flag = this.func_213322_ci().field_72448_b <= 0.0;
        double d1 = this.field_70163_u;
        double d0 = 0.5;
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (!this.func_189652_ae() && !this.func_70051_ag()) {
            Vec3d vec3d2 = this.func_213322_ci();
            double d2 = flag && Math.abs(vec3d2.field_72448_b - 0.005) >= 0.003 && Math.abs(vec3d2.field_72448_b - d0 / 16.0) < 0.003 ? -0.003 : vec3d2.field_72448_b - d0 / 16.0;
            this.func_213293_j(vec3d2.field_72450_a, d2, vec3d2.field_72449_c);
        }
        Vec3d vec3d6 = this.func_213322_ci();
        if (this.field_70123_F && this.func_70038_c(vec3d6.field_72450_a, vec3d6.field_72448_b + (double)0.6f - this.field_70163_u + d1, vec3d6.field_72449_c)) {
            this.func_213293_j(vec3d6.field_72450_a, 0.3f, vec3d6.field_72449_c);
        }
    }

    public void hatch() {
        if (!this.field_70170_p.field_72995_K) {
            AbstractDragonEntity newDragon = (AbstractDragonEntity)this.containedDragon.func_200721_a(this.field_70170_p);
            if (newDragon == null) {
                this.safeError();
                return;
            }
            newDragon.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            newDragon.func_70873_a(newDragon.getEggProperties().getGrowthTime());
            newDragon.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_180425_c()), SpawnReason.BREEDING, null, null);
            this.field_70170_p.func_217376_c((Entity)newDragon);
        } else {
            int i = 0;
            while ((float)i < this.func_213311_cf() * 25.0f) {
                double x = this.field_70146_Z.nextGaussian() * (double)0.2f;
                double y = this.field_70146_Z.nextDouble() * (double)0.45f;
                double z = this.field_70146_Z.nextGaussian() * (double)0.2f;
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)WRItems.DRAGON_EGG.get())), this.field_70165_t, this.field_70163_u, this.field_70161_v, x, y, z);
                ++i;
            }
        }
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_203279_ix, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        this.func_70106_y();
    }

    public void crack(boolean sendPacket) {
        this.func_184185_a(SoundEvents.field_203280_iy, 1.0f, 1.0f);
        if (sendPacket) {
            NetworkUtils.sendAnimationPacket(this, WIGGLE_ANIMATION);
        } else {
            this.setAnimation(WIGGLE_ANIMATION);
        }
    }

    private void safeError() {
        ModUtils.L.error("THIS ISNT A DRAGON WTF KIND OF ABOMINATION IS THIS HATCHING?!?! Unknown Entity Type for Dragon Egg @ {}", (Object)this.func_180425_c());
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("hatchTime", this.hatchTime);
        tag.func_74778_a("dragonType", this.getDragonKey());
        ItemStack itemStack = new ItemStack((IItemProvider)WRItems.DRAGON_EGG.get());
        itemStack.func_77982_d(tag);
        InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (ItemStack)itemStack);
        this.func_70106_y();
        return true;
    }

    public DragonEggProperties getProperties() {
        if (this.properties == null) {
            try {
                this.properties = ((AbstractDragonEntity)Objects.requireNonNull(this.containedDragon.func_200721_a(this.field_70170_p))).getEggProperties();
                return this.properties;
            }
            catch (NullPointerException e) {
                ModUtils.L.warn("Unknown Dragon Type!!!");
                this.properties = new DragonEggProperties(0.65f, 1.0f, 12000);
                return this.properties;
            }
        }
        return this.properties;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack stack = new ItemStack((IItemProvider)WRItems.DRAGON_EGG.get());
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("dragonType", this.getDragonKey());
        tag.func_74768_a("hatchTime", this.getProperties().getHatchTime());
        stack.func_77982_d(tag);
        return stack;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.getProperties().getSize();
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_180714_a(this.getDragonKey());
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.containedDragon = ModUtils.getTypeByString(buffer.func_218666_n());
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
        this.setAnimationTick(0);
        if (this.field_70170_p.field_72995_K && animation == WIGGLE_ANIMATION) {
            this.wiggleInvert = this.field_70146_Z.nextBoolean();
            this.wiggleInvert2 = this.field_70146_Z.nextBoolean();
        }
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, WIGGLE_ANIMATION};
    }
}

