/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.entities.multipart;

import WolfShotz.Wyrmroost.registry.WREntities;
import java.util.List;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class MultiPartEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public LivingEntity host;
    public float radius;
    public float angleYaw;
    public float offsetY;
    public float sizeX;
    public float sizeY;
    public float damageMultiplier;

    public MultiPartEntity(EntityType<? extends MultiPartEntity> multiPart, World world) {
        super(multiPart, world);
    }

    public MultiPartEntity(LivingEntity host, float radius, float angleYaw, float offsetY, float sizeX, float sizeY, float damageMultiplier) {
        super((EntityType)WREntities.MULTIPART.get(), host.field_70170_p);
        this.host = host;
        this.radius = radius;
        this.angleYaw = (angleYaw + 90.0f) * ((float)Math.PI / 180);
        this.offsetY = offsetY;
        this.damageMultiplier = damageMultiplier;
        this.resize(sizeX, sizeY);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && (this.host == null || !this.host.func_70089_S())) {
            this.func_70106_y();
            return;
        }
        this.func_70107_b(this.host.field_70165_t + (double)this.radius * Math.cos((double)this.host.field_70761_aq * (Math.PI / 180) + (double)this.angleYaw), this.host.field_70163_u + (double)this.offsetY, this.host.field_70161_v + (double)this.radius * Math.sin((double)this.host.field_70761_aq * (Math.PI / 180) + (double)this.angleYaw));
        this.collideWithNearbyEntities();
        super.func_70030_z();
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (!(this.host instanceof AgeableEntity)) {
            return this.host.func_184230_a(player, hand);
        }
        return ((AgeableEntity)this.host).func_184645_a(player, hand);
    }

    public void resizeAndPosition(float radius, float angleYaw, float offsetY, float sizeX, float sizeY) {
        this.radius = radius;
        this.angleYaw = (angleYaw + 90.0f) * ((float)Math.PI / 180);
        this.offsetY = offsetY;
        this.resize(sizeX, sizeY);
    }

    public void resize(float sizeX, float sizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.func_213323_x_();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)this.sizeX, (float)this.sizeY);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return this.host.func_70097_a(source, damage * this.damageMultiplier);
    }

    public boolean func_70028_i(Entity entity) {
        return this == entity || this.host == entity;
    }

    public boolean equals(Object o) {
        return this == o || this.host == o;
    }

    public int hashCode() {
        return this.host.func_145782_y();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public boolean func_70067_L() {
        return true;
    }

    public void collideWithNearbyEntities() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        entities.stream().filter(entity -> entity != this.host && !(entity instanceof MultiPartEntity) && entity.func_70104_M()).forEach(e -> this.host.func_70108_f(e));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.host.getPickedResult(target);
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buf) {
        buf.writeInt(this.host.func_145782_y());
        buf.writeFloat(this.radius);
        buf.writeFloat(this.angleYaw);
        buf.writeFloat(this.offsetY);
        buf.writeFloat(this.damageMultiplier);
        buf.writeFloat(this.sizeX);
        buf.writeFloat(this.sizeY);
    }

    public void readSpawnData(PacketBuffer buf) {
        this.host = (LivingEntity)this.field_70170_p.func_73045_a(buf.readInt());
        this.radius = buf.readFloat();
        this.angleYaw = buf.readFloat();
        this.offsetY = buf.readFloat();
        this.damageMultiplier = buf.readFloat();
        this.resize(buf.readFloat(), buf.readFloat());
    }
}

