/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.io.screen;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DebugScreen
extends Screen {
    public final AbstractDragonEntity dragon;

    public DebugScreen(AbstractDragonEntity dragon) {
        super((ITextComponent)new StringTextComponent("debug_screen"));
        this.dragon = dragon;
    }

    protected void init() {
        if (this.dragon.getAnimations() != null && this.dragon.getAnimations().length > 0) {
            for (int i = 0; i < this.dragon.getAnimations().length; ++i) {
                Animation anim = this.dragon.getAnimations()[i];
                this.addButton((Widget)new Button(i * 50 + this.width / 2 - this.dragon.getAnimations().length * 25, 225, 50, 12, "Anim: " + i, b -> {
                    this.dragon.setAnimation(anim);
                    this.onClose();
                }));
            }
        }
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        super.render(p_render_1_, p_render_2_, p_render_3_);
        String gender = this.dragon.getGender() ? "male" : "female";
        this.drawCenteredString(this.font, this.dragon.func_145748_c_().func_150261_e(), this.width / 2, 15, 0xFFFFFF);
        this.drawCenteredString(this.font, "isSleeping: " + this.dragon.func_70608_bn(), this.width / 2 + 50, 50, 0xFFFFFF);
        this.drawCenteredString(this.font, "isTamed: " + this.dragon.func_70909_n(), this.width / 2 - 50, 50, 0xFFFFFF);
        this.drawCenteredString(this.font, "isSitting: " + this.dragon.func_70906_o(), this.width / 2 - 50, 75, 0xFFFFFF);
        this.drawCenteredString(this.font, "isFlying: " + this.dragon.isFlying(), this.width / 2 + 50, 75, 0xFFFFFF);
        this.drawCenteredString(this.font, "variant: " + this.dragon.getVariant(), this.width / 2 - 50, 100, 0xFFFFFF);
        this.drawCenteredString(this.font, "gender: " + gender, this.width / 2 + 50, 100, 0xFFFFFF);
        this.drawCenteredString(this.font, "health: " + this.dragon.func_110143_aJ() + " / " + this.dragon.func_110138_aP(), this.width / 2 - 50, 125, 0xFFFFFF);
        this.drawCenteredString(this.font, "position: " + this.dragon.func_213303_ch(), this.width / 2, 150, 0xFFFFFF);
        this.drawCenteredString(this.font, "motion: " + this.dragon.func_213322_ci(), this.width / 2, 175, 0xFFFFFF);
        this.drawCenteredString(this.font, "moveTo position: " + this.dragon.func_70661_as().func_75505_d(), this.width / 2, 200, 0xFFFFFF);
    }

    public boolean isPauseScreen() {
        return true;
    }
}

