/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.io.screen.base;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.util.io.ContainerBase;
import WolfShotz.Wyrmroost.util.io.NameFieldWidget;
import WolfShotz.Wyrmroost.util.network.messages.EntityRenameMessage;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ContainerScreenBase<T extends ContainerBase<?>>
extends ContainerScreen<T> {
    public static final ResourceLocation STANDARD_GUI = Wyrmroost.rl("textures/io/dragonscreen/dragoninv.png");
    public static final ResourceLocation HEART = new ResourceLocation("textures/particle/heart.png");
    public static final ResourceLocation SPECIAL = new ResourceLocation("textures/particle/glitter_7.png");
    public T dragonInv;
    public ResourceLocation background;
    public Random rand = new Random();
    public NameFieldWidget nameField;
    public String prevName;
    public int textureWidth;
    public int textureHeight;

    public ContainerScreenBase(T container, PlayerInventory playerInv, ITextComponent name) {
        super(container, playerInv, name);
        this.dragonInv = container;
        this.background = STANDARD_GUI;
        this.textureHeight = 256;
        this.textureWidth = 256;
        this.field_147000_g = 164;
    }

    protected void init() {
        super.init();
        this.prevName = ((ContainerBase)((Object)this.dragonInv)).dragon.func_145818_k_() ? ((ContainerBase)((Object)this.dragonInv)).dragon.func_200201_e().func_150261_e() : ((ContainerBase)((Object)this.dragonInv)).dragon.func_145748_c_().func_150261_e();
        this.nameField = this.createNameField();
    }

    public void tick() {
        super.tick();
        this.nameField.func_146178_a();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.nameField.render(mouseX, mouseY, partialTicks);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawHealth(115, 5);
        if (((AbstractDragonEntity)((ContainerBase)((Object)this.dragonInv)).dragon).isSpecial()) {
            this.drawSpecialIcon(6, 11);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderEntity(mouseX, mouseY);
        this.bindTexture(this.background);
        ContainerScreenBase.blit((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)this.textureWidth, (int)this.textureHeight);
    }

    public boolean keyPressed(int p1, int p2, int p3) {
        this.nameField.keyPressed(p1, p2, p3);
        if (this.nameField.isFocused() && p1 == 257) {
            if (!((ContainerBase)((Object)this.dragonInv)).dragon.func_200200_C_().func_150261_e().equals(this.nameField.func_146179_b())) {
                Wyrmroost.NETWORK.sendToServer((Object)new EntityRenameMessage((Entity)((ContainerBase)((Object)this.dragonInv)).dragon, (ITextComponent)new StringTextComponent(this.nameField.func_146179_b())));
            }
            this.nameField.func_146195_b(false);
        }
        return this.nameField.isFocused() && this.nameField.func_146176_q() && p1 != 256 || super.keyPressed(p1, p2, p3);
    }

    public void drawHealth(int x, int y) {
        int health = (int)Math.floor(((ContainerBase)((Object)this.dragonInv)).dragon.func_110143_aJ() / 2.0f);
        boolean shake = (float)health < ((ContainerBase)((Object)this.dragonInv)).dragon.func_110138_aP() / 5.0f;
        GlStateManager.pushMatrix();
        if (shake) {
            GlStateManager.translated((double)0.0, (double)(this.rand.nextDouble() * 2.0), (double)0.0);
        }
        this.bindTexture(HEART);
        ContainerScreenBase.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)15, (int)15, (int)15, (int)15);
        this.drawCenteredString(this.font, Integer.toString(health), x + 8, y + 5, 0xFFFFFF);
        GlStateManager.popMatrix();
    }

    public void drawSpecialIcon(int x, int y) {
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)1.0f, (float)0.65f, (float)0.0f, (float)1.0f);
        this.bindTexture(SPECIAL);
        ContainerScreenBase.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)10, (int)10, (int)10, (int)10);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    public <T extends Widget> T addButton(T widget) {
        return (T)super.addButton(widget);
    }

    public List<IGuiEventListener> getChildren() {
        return this.children;
    }

    public void renderEntity(int mouseX, int mouseY) {
        InventoryScreen.func_147046_a((int)(this.field_147003_i + 40), (int)(this.field_147009_r + 60), (int)15, (float)(this.field_147003_i + 40 - mouseX), (float)(this.field_147009_r + 75 - 30 - mouseY), ((ContainerBase)((Object)this.dragonInv)).dragon);
    }

    public NameFieldWidget createNameField() {
        return new NameFieldWidget(this.font, this.field_147003_i + 72, this.field_147009_r + 22, 100, 12, this);
    }

    public void bindTexture(ResourceLocation texture) {
        assert (this.minecraft != null);
        this.minecraft.func_110434_K().func_110577_a(texture);
    }

    public static class BasicEntityScreen<T extends ContainerBase<?>>
    extends ContainerScreenBase<T> {
        public BasicEntityScreen(T container, PlayerInventory playerInv, ITextComponent name) {
            super(container, playerInv, name);
        }

        @Override
        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            super.func_146976_a(partialTicks, mouseX, mouseY);
            BasicEntityScreen.blit((int)(this.field_147003_i + 70), (int)(this.field_147009_r + 55), (float)0.0f, (float)164.0f, (int)18, (int)18, (int)this.textureWidth, (int)this.textureHeight);
        }

        @Override
        protected void func_146979_b(int mouseX, int mouseY) {
            super.func_146979_b(mouseX, mouseY);
        }
    }
}

