/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.items;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.content.items.base.ArmorMaterialList;
import WolfShotz.Wyrmroost.util.ModUtils;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class DragonArmorItem
extends Item {
    public static final UUID ARMOR_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private DragonArmorType type;

    public DragonArmorItem(DragonArmorType type) {
        super(ModUtils.itemBuilder().func_200917_a(1));
        this.type = type;
    }

    public int func_77619_b() {
        switch (this.type) {
            default: {
                return ArmorMaterial.IRON.func_200900_a();
            }
            case GOLD: {
                return ArmorMaterial.GOLD.func_200900_a();
            }
            case DIAMOND: {
                return ArmorMaterial.DIAMOND.func_200900_a();
            }
            case PLATINUM: {
                return ArmorMaterialList.PLATINUM.func_200900_a();
            }
            case BLUE_GEODE: 
        }
        return ArmorMaterialList.BLUE_GEODE.func_200900_a();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_180310_c;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public DragonArmorType getType() {
        return this.type;
    }

    public int getDmgReduction() {
        return this.type.getDmgReduction();
    }

    public static DragonArmorItem getArmorInInv(IItemHandler inv, int slot) {
        Item item = inv.getStackInSlot(slot).func_77973_b();
        return item instanceof DragonArmorItem ? (DragonArmorItem)item : null;
    }

    public static void setDragonArmored(AbstractDragonEntity dragon, int slot) {
        if (!dragon.field_70170_p.field_72995_K) {
            IAttributeInstance armorAttribute = dragon.func_110148_a(SharedMonsterAttributes.field_188791_g);
            DragonArmorItem armor = DragonArmorItem.getArmorInInv((IItemHandler)dragon.getInvHandler(), slot);
            armorAttribute.func_188479_b(ARMOR_UUID);
            if (armor != null) {
                armorAttribute.func_111121_a(new AttributeModifier("Armor Modifier", (double)armor.getDmgReduction(), AttributeModifier.Operation.ADDITION).func_111168_a(true));
            }
        }
    }

    public static enum DragonArmorType {
        IRON(5),
        GOLD(7),
        DIAMOND(11),
        PLATINUM(6),
        BLUE_GEODE(11),
        RED_GEODE(12),
        PURPLE_GEODE(13);

        private int dmgReduction;

        private DragonArmorType(int dmgReduction) {
            this.dmgReduction = dmgReduction;
        }

        public int getDmgReduction() {
            return this.dmgReduction;
        }
    }
}

