/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.items;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.content.entities.multipart.MultiPartEntity;
import WolfShotz.Wyrmroost.util.ModUtils;
import WolfShotz.Wyrmroost.util.QuikMaths;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class DragonStaffItem
extends Item {
    public DragonStaffItem() {
        super(ModUtils.itemBuilder().func_200917_a(1));
    }

    @Nullable
    public static AbstractDragonEntity getDragon(ItemStack stack, ServerWorld world) {
        CompoundNBT tag = stack.func_77978_p();
        return DragonStaffItem.isBound(stack) ? (AbstractDragonEntity)world.func_217461_a(tag.func_186857_a("boundID")) : null;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        AbstractDragonEntity dragon = DragonStaffItem.getDragonTarget((Entity)target, player);
        if (dragon == null) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        try {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)dragon, buf -> buf.writeInt(dragon.func_145782_y()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity target) {
        AbstractDragonEntity dragon = DragonStaffItem.getDragonTarget(target, player);
        if (dragon == null) {
            return false;
        }
        CompoundNBT tag = stack.func_196082_o();
        tag.func_186854_a("boundID", dragon.func_110124_au());
        stack.func_77982_d(tag);
        player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockPos homePos = context.func_195995_a();
        World world = context.func_195991_k();
        if (!world.func_180495_p(homePos).func_200132_m()) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        AbstractDragonEntity dragon = DragonStaffItem.getDragon(context.func_195996_i(), ModUtils.getServerWorld(player));
        if (dragon.getHomePos().isPresent() && homePos.equals((Object)dragon.getHomePos().get().func_177979_c(1))) {
            dragon.setHomePos(Optional.empty());
        } else {
            dragon.setHomePos(homePos.func_177981_b(1));
        }
        player.func_146105_b((ITextComponent)new StringTextComponent(String.format("Set Home Position to: %s, %s, %s", Math.ceil(homePos.func_177958_n()), Math.ceil(homePos.func_177956_o()), Math.ceil(homePos.func_177952_p()))), true);
        dragon.playSound(SoundEvents.field_187909_gi, 1.0f, 1.0f, true);
        return ActionResultType.SUCCESS;
    }

    public boolean func_77636_d(ItemStack stack) {
        return DragonStaffItem.isBound(stack);
    }

    public static boolean isBound(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return false;
        }
        return tag.func_186855_b("boundID");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            stack.func_77982_d(new CompoundNBT());
            player.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
            return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
        }
        if (!world.field_72995_K) {
            RayTraceResult rtr = QuikMaths.rayTrace(world, player, 50.0, true);
            AbstractDragonEntity dragon = DragonStaffItem.getDragon(stack, ModUtils.getServerWorld(player));
            if (rtr.func_216346_c() == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult ertr = (EntityRayTraceResult)rtr;
                AbstractDragonEntity dragonTarget = DragonStaffItem.getDragonTarget(ertr.func_216348_a(), player);
                if (dragonTarget != null && dragonTarget.func_70902_q() == player) {
                    boolean flag = false;
                    if (dragonTarget.isFlying()) {
                        dragonTarget.tryTeleportToOwner();
                        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_191244_bn, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                        flag = true;
                    } else if (dragonTarget.func_70906_o()) {
                        dragonTarget.setSit(false);
                        flag = true;
                    }
                    if (flag) {
                        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_219603_Y, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
                    }
                }
                if (!DragonStaffItem.isBound(stack)) {
                    return ActionResult.newResult((ActionResultType)ActionResultType.PASS, (Object)stack);
                }
                if (!(ertr.func_216348_a() instanceof LivingEntity)) {
                    return ActionResult.newResult((ActionResultType)ActionResultType.PASS, (Object)stack);
                }
                LivingEntity entity = (LivingEntity)ertr.func_216348_a();
                if (dragon.func_142018_a(entity, dragon.func_70902_q())) {
                    dragon.setSit(false);
                    dragon.func_70624_b(entity);
                    player.func_184185_a(SoundEvents.field_187606_E, 1.0f, 0.2f);
                    return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
                }
            }
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.PASS, (Object)stack);
    }

    @Nullable
    public static AbstractDragonEntity getDragonTarget(Entity target, PlayerEntity player) {
        AbstractDragonEntity dragon;
        if (!target.func_70089_S()) {
            return null;
        }
        if (target instanceof AbstractDragonEntity) {
            dragon = (AbstractDragonEntity)target;
        } else if (target instanceof MultiPartEntity) {
            dragon = (AbstractDragonEntity)((MultiPartEntity)target).host;
        } else {
            return null;
        }
        if (dragon.func_70902_q() != player) {
            return null;
        }
        return dragon;
    }
}

