/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.content.items;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.util.ModUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class SoulCrystalItem
extends Item {
    public SoulCrystalItem() {
        super(ModUtils.itemBuilder().func_200917_a(1));
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        World world = player.field_70170_p;
        if (this.containsDragon(stack)) {
            return false;
        }
        if (!(target instanceof AbstractDragonEntity)) {
            return false;
        }
        AbstractDragonEntity dragon = (AbstractDragonEntity)target;
        if (dragon.func_70902_q() != player) {
            return false;
        }
        if (!dragon.func_184188_bt().isEmpty()) {
            dragon.func_184226_ay();
        }
        if (!world.field_72995_K) {
            CompoundNBT tag = new CompoundNBT();
            target.func_189511_e(tag);
            tag.func_74778_a("entity", EntityType.func_200718_a((EntityType)dragon.func_200600_R()).toString());
            stack.func_77982_d(tag);
            dragon.func_70106_y();
            player.func_184611_a(hand, stack);
        } else {
            int i = 0;
            while ((float)i <= dragon.func_213311_cf() * 25.0f) {
                double calcX = (double)MathHelper.func_76134_b((float)((float)i + 41252.96f)) * ((double)dragon.func_213311_cf() * 1.5);
                double calcZ = (double)MathHelper.func_76126_a((float)((float)i + 41252.96f)) * ((double)dragon.func_213311_cf() * 1.5);
                double x = dragon.field_70165_t + calcX;
                double y = dragon.field_70163_u + (double)(dragon.func_213302_cg() * 1.8f);
                double z = dragon.field_70161_v + calcZ;
                double xMot = -calcX / 5.0;
                double yMot = -(dragon.func_213302_cg() / 8.0f);
                double zMot = -calcZ / 5.0;
                world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, x, y, z, xMot, yMot, zMot);
                ++i;
            }
        }
        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_193781_bp, SoundCategory.AMBIENT, 1.0f, 1.0f);
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        if (!this.containsDragon(stack)) {
            return super.func_195939_a(context);
        }
        World world = context.func_195991_k();
        AbstractDragonEntity entity = this.getEntity(stack, world);
        BlockPos pos = context.func_195995_a().func_177972_a(context.func_196000_l());
        if (!world.field_72995_K) {
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            stack.func_77982_d(null);
            world.func_217376_c((Entity)entity);
        }
        if (world.field_72995_K) {
            PlayerEntity player = context.func_195999_j();
            EntitySize size = entity.func_213305_a(entity.func_213283_Z());
            player.func_184609_a(context.func_221531_n());
            double posX = (double)pos.func_177958_n() + 0.5;
            double posY = (float)pos.func_177956_o() + size.field_220316_b / 2.0f;
            double posZ = (double)pos.func_177952_p() + 0.5;
            int i = 0;
            while ((float)i < entity.func_213311_cf() * 25.0f) {
                double x = (double)MathHelper.func_76134_b((float)((float)i + 41252.96f)) * ((double)entity.func_213311_cf() * 1.5);
                double z = (double)MathHelper.func_76126_a((float)((float)i + 41252.96f)) * ((double)entity.func_213311_cf() * 1.5);
                double xMot = x / 10.0;
                double yMot = entity.func_213302_cg() / 18.0f;
                double zMot = z / 10.0;
                world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, posX, posY, posZ, xMot, yMot, zMot);
                world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, posX, posY + (double)i * 0.25, posZ, 0.0, 0.0, 0.0);
                ++i;
            }
        }
        world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_191244_bn, SoundCategory.AMBIENT, 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.containsDragon(stack)) {
            AbstractDragonEntity dragon = this.getEntity(stack, world);
            tooltip.add((ITextComponent)new StringTextComponent("Name: " + dragon.func_200200_C_().func_150261_e()));
            tooltip.add(new StringTextComponent("Health: " + Math.round(dragon.func_110143_aJ()) / 2 + " ").func_150257_a(new StringTextComponent(Character.toString('\u2764')).func_211708_a(TextFormatting.DARK_RED)));
            tooltip.add((ITextComponent)new StringTextComponent("Tamer: " + dragon.func_70902_q().func_200200_C_().func_150261_e()));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        if (this.containsDragon(stack)) {
            name.func_211708_a(TextFormatting.AQUA).func_211708_a(TextFormatting.ITALIC);
        }
        return name;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.containsDragon(stack);
    }

    private boolean containsDragon(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("entity");
    }

    private AbstractDragonEntity getEntity(ItemStack stack, World world) {
        EntityType type = EntityType.func_220327_a((String)stack.func_77978_p().func_74779_i("entity")).orElse(null);
        if (type == null) {
            return null;
        }
        AbstractDragonEntity entity = (AbstractDragonEntity)type.func_200721_a(world);
        entity.func_70020_e(stack.func_77978_p());
        return entity;
    }
}

