/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.registry;

import WolfShotz.Wyrmroost.content.entities.dragon.butterflyleviathan.ButterflyLeviathanEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.canariwyvern.CanariWyvernEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.dfruitdrake.DragonFruitDrakeEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.minutus.MinutusEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.owdrake.OWDrakeEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.rooststalker.RoostStalkerEntity;
import WolfShotz.Wyrmroost.content.entities.dragon.sliverglider.SilverGliderEntity;
import WolfShotz.Wyrmroost.content.entities.dragonegg.DragonEggEntity;
import WolfShotz.Wyrmroost.content.entities.multipart.MultiPartEntity;
import WolfShotz.Wyrmroost.content.items.CustomSpawnEggItem;
import WolfShotz.Wyrmroost.registry.WRItems;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class WREntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = new DeferredRegister(ForgeRegistries.ENTITIES, "wyrmroost");
    public static final RegistryObject<EntityType<MinutusEntity>> MINUTUS = WREntities.register("minutus", 14073020, 14595783, WREntities.creature(MinutusEntity::new).func_220321_a(0.6f, 0.2f));
    public static final RegistryObject<EntityType<OWDrakeEntity>> OVERWORLD_DRAKE = WREntities.register("overworld_drake", 7898902, 4088382, WREntities.creature(OWDrakeEntity::new).func_220321_a(2.376f, 2.45f));
    public static final RegistryObject<EntityType<SilverGliderEntity>> SILVER_GLIDER = WREntities.register("silver_glider", 0xC8C8C8, 0xC4C4C4, WREntities.creature(SilverGliderEntity::new).func_220321_a(1.5f, 0.75f));
    public static final RegistryObject<EntityType<RoostStalkerEntity>> ROOSTSTALKER = WREntities.register("roost_stalker", 5378061, 0x959595, WREntities.creature(RoostStalkerEntity::new).func_220321_a(0.65f, 0.5f));
    public static final RegistryObject<EntityType<ButterflyLeviathanEntity>> BUTTERFLY_LEVIATHAN = WREntities.register("butterfly_leviathan", 1517628, 8023898, EntityType.Builder.func_220322_a(ButterflyLeviathanEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(4.0f, 3.0f));
    public static final RegistryObject<EntityType<DragonFruitDrakeEntity>> DRAGON_FRUIT_DRAKE = WREntities.register("dragon_fruit_drake", 14703770, 7898902, WREntities.creature(DragonFruitDrakeEntity::new).func_220321_a(1.5f, 1.9f));
    public static final RegistryObject<EntityType<CanariWyvernEntity>> CANARI_WYVERN = WREntities.register("canari_wyvern", 1908520, 4795918, WREntities.creature(CanariWyvernEntity::new).func_220321_a(0.7f, 0.85f));
    public static final RegistryObject<EntityType<DragonEggEntity>> DRAGON_EGG = WREntities.register("dragon_egg", EntityType.Builder.func_220322_a(DragonEggEntity::new, (EntityClassification)EntityClassification.MISC).func_200705_b());
    public static final RegistryObject<EntityType<MultiPartEntity>> MULTIPART = WREntities.register("multipart_entity", EntityType.Builder.func_220322_a(MultiPartEntity::new, (EntityClassification)EntityClassification.MISC).func_200705_b().func_200706_c().setShouldReceiveVelocityUpdates(false));

    public static void registerEntityWorldSpawns() {
        WREntities.registerSpawnEntry((EntityType)OVERWORLD_DRAKE.get(), 8, 1, 3, WREntities.getByTypes(BiomeDictionary.Type.SANDY, BiomeDictionary.Type.PLAINS));
        WREntities.registerSpawnEntry((EntityType)MINUTUS.get(), 35, 1, 1, WREntities.getByTypes(BiomeDictionary.Type.SANDY).stream().filter(b -> !BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)).collect(Collectors.toSet()));
        WREntities.registerCustomSpawnEntry((EntityType)SILVER_GLIDER.get(), 2, 2, 5, EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SilverGliderEntity::canSpawnHere, WREntities.getByTypes(BiomeDictionary.Type.BEACH, BiomeDictionary.Type.PLAINS));
        WREntities.registerSpawnEntry((EntityType)ROOSTSTALKER.get(), 7, 3, 18, WREntities.getByTypes(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN));
        DragonFruitDrakeEntity.handleSpawning();
        ButterflyLeviathanEntity.handleSpawning();
        WREntities.registerSpawnEntry((EntityType)CANARI_WYVERN.get(), 9, 2, 5, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
    }

    private static <T extends Entity> EntityType.Builder<T> creature(EntityType.IFactory<T> entity) {
        return EntityType.Builder.func_220322_a(entity, (EntityClassification)EntityClassification.CREATURE);
    }

    private static <T extends MobEntity> void registerSpawnEntry(EntityType<T> entity, int frequency, int minAmount, int maxAmount, Set<Biome> biomes) {
        WREntities.registerBiomeSpawnEntry(entity, frequency, minAmount, maxAmount, biomes);
        EntitySpawnPlacementRegistry.func_209343_a(entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (type, world, reason, blockPos, rng) -> blockPos.func_177956_o() > world.func_181545_F() - 20 && world.func_201669_a(blockPos, 0) > 8);
    }

    private static <T extends MobEntity> void registerCustomSpawnEntry(EntityType<T> entity, int frequency, int minAmount, int maxAmount, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightMapType, EntitySpawnPlacementRegistry.IPlacementPredicate canSpawnHere, Set<Biome> biomes) {
        WREntities.registerBiomeSpawnEntry(entity, frequency, minAmount, maxAmount, biomes);
        EntitySpawnPlacementRegistry.func_209343_a(entity, (EntitySpawnPlacementRegistry.PlacementType)placementType, (Heightmap.Type)heightMapType, (EntitySpawnPlacementRegistry.IPlacementPredicate)canSpawnHere);
    }

    public static void registerBiomeSpawnEntry(EntityType<?> entity, int frequency, int minAmount, int maxAmount, Set<Biome> biomes) {
        biomes.forEach(biome -> biome.func_76747_a(entity.func_220339_d()).add(new Biome.SpawnListEntry(entity, frequency, minAmount, maxAmount)));
    }

    public static Set<Biome> getByTypes(BiomeDictionary.Type ... types) {
        HashSet biomes = Sets.newHashSet();
        for (BiomeDictionary.Type type : types) {
            biomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
        }
        return biomes;
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> register(String name, EntityType.Builder<T> type) {
        return ENTITIES.register(name, () -> type.func_206830_a("wyrmroost:" + name));
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> register(String name, int primColor, int secColor, EntityType.Builder<T> type) {
        RegistryObject object = WREntities.register(name, type);
        WRItems.register(name + "_egg", () -> new CustomSpawnEggItem(() -> ((RegistryObject)object).get(), primColor, secColor));
        return object;
    }
}

