/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.registry;

import WolfShotz.Wyrmroost.registry.WRBlocks;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.util.ModUtils;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Items;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class WRFluids {
    public static final DeferredRegister<Fluid> FLUIDS = new DeferredRegister(ForgeRegistries.FLUIDS, "wyrmroost");

    public static FluidRegistry register(String name, Function<Boolean, Supplier<? extends FlowingFluid>> fluidFunc, Supplier<FlowingFluidBlock> block) {
        RegistryObject s = FLUIDS.register(name, fluidFunc.apply(true));
        RegistryObject f = FLUIDS.register("flowing_" + name, fluidFunc.apply(false));
        RegistryObject b = WRBlocks.BLOCKS.register(name, block);
        RegistryObject bu = WRItems.ITEMS.register(name + "_bucket", () -> new BucketItem((Supplier)s, ModUtils.itemBuilder().func_200919_a(Items.field_151133_ar).func_200917_a(1)));
        return new FluidRegistry((RegistryObject<FlowingFluid>)s, (RegistryObject<FlowingFluid>)f, (RegistryObject<FlowingFluidBlock>)b, (RegistryObject<BucketItem>)bu);
    }

    public static class FluidRegistry {
        public final RegistryObject<FlowingFluid> source;
        public final RegistryObject<FlowingFluid> flow;
        public final RegistryObject<FlowingFluidBlock> block;
        public final RegistryObject<BucketItem> bucket;

        public FluidRegistry(RegistryObject<FlowingFluid> source, RegistryObject<FlowingFluid> flow, RegistryObject<FlowingFluidBlock> block, RegistryObject<BucketItem> bucket) {
            this.source = source;
            this.flow = flow;
            this.block = block;
            this.bucket = bucket;
        }

        public FlowingFluid getSource() {
            return (FlowingFluid)this.source.get();
        }

        public FlowingFluid getFlow() {
            return (FlowingFluid)this.flow.get();
        }

        public FlowingFluidBlock getBlock() {
            return (FlowingFluidBlock)this.block.get();
        }

        public BucketItem getBucketItem() {
            return (BucketItem)this.bucket.get();
        }
    }
}

