/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.registry;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.registry.WRBlocks;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class WRWorld {
    public static final DeferredRegister<Feature<?>> FEATURES = new DeferredRegister(ForgeRegistries.FEATURES, "wyrmroost");
    private static final Predicate<Biome> NETHER_FILTER = biome -> BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER).stream().anyMatch(biome::equals);
    private static final Predicate<Biome> END_FILTER = biome -> BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END).stream().anyMatch(biome::equals);

    private static <C extends IFeatureConfig, T extends Feature<C>> RegistryObject<T> feature(String name, Supplier<T> feature) {
        return FEATURES.register(name, feature);
    }

    private static IStructurePieceType structurePiece(String name, IStructurePieceType piece) {
        return (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)Wyrmroost.rl(name), (Object)piece);
    }

    public static void setupWorldGen() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            WRWorld.ore(biome);
        }
    }

    public static void ore(Biome biome) {
        if (NETHER_FILTER.test(biome)) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ((Block)WRBlocks.RED_GEODE_ORE.get()).func_176223_P(), 4), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(16, 0, 0, 128)));
            return;
        }
        if (END_FILTER.test(biome)) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202294_an, (IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150377_bs.func_176223_P(), ((Block)WRBlocks.PURPLE_GEODE_ORE.get()).func_176223_P()), (Placement)Placement.field_215031_q, (IPlacementConfig)new CountRangeConfig(16, 0, 0, 128)));
            return;
        }
        WRWorld.registerOreEntry(biome, ((Block)WRBlocks.BLUE_GEODE_ORE.get()).func_176223_P(), 8, 1, 0, 0, 20);
        WRWorld.registerOreEntry(biome, ((Block)WRBlocks.PLATINUM_ORE.get()).func_176223_P(), 9, 2, 0, 0, 28);
    }

    private static void registerOreEntry(Biome biome, BlockState state, int size, int count, int bottomOffset, int topOffset, int maximum) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, state, size), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(count, bottomOffset, topOffset, maximum)));
    }
}

