/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigData {
    public static boolean debugMode = false;
    public static int homeRadius = 16;
    public static double dfdBabyChance = 0.3;
    public static boolean disableFrustumCheck = true;

    public static class ClientConfig {
        private static final Pair<ClientConfig, ForgeConfigSpec> SPEC_PAIR = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        public static final ClientConfig CLIENT = (ClientConfig)SPEC_PAIR.getLeft();
        public static final ForgeConfigSpec CLIENT_SPEC = (ForgeConfigSpec)SPEC_PAIR.getRight();
        public final ForgeConfigSpec.BooleanValue disableFrustumCheck;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Wyrmroost Client Options").push("General");
            this.disableFrustumCheck = builder.comment("Disables Frustum check when rendering (Dragons parts dont go poof when looking too far) - Only applies to bigger bois").translation("config.wyrmroost.disableFrustumCheck").define("disableFrustumCheck", true);
            builder.pop();
        }

        public static void reload() {
            disableFrustumCheck = (Boolean)ClientConfig.CLIENT.disableFrustumCheck.get();
        }
    }

    public static class CommonConfig {
        private static final Pair<CommonConfig, ForgeConfigSpec> SPEC_PAIR = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        public static final CommonConfig COMMON = (CommonConfig)SPEC_PAIR.getLeft();
        public static final ForgeConfigSpec COMMON_SPEC = (ForgeConfigSpec)SPEC_PAIR.getRight();
        public final ForgeConfigSpec.BooleanValue debugMode;
        public final ForgeConfigSpec.IntValue homeRadius;
        public final ForgeConfigSpec.DoubleValue dfdBabyChance;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Wyrmroost General Options").push("general");
            this.debugMode = builder.comment("Do not enable this unless you are told to!").translation("config.wyrmroost.debug").define("debugMode", false);
            this.homeRadius = builder.comment("How far dragons can travel from their home points").translation("config.wyrmroost.homeradius").defineInRange("homeRadius", 16, 6, 1024);
            builder.comment("Wyrmroost Dragon Options").push("dragons");
            this.dfdBabyChance = builder.comment("Chances for a Dragon Fruit Drake to spawn as a baby. 0 = No Chance, 1 = (practically) Guaranteed. Higher values are better chances").translation("config.wyrmroost.dfdbabychance").defineInRange("dfdBabyChance", 0.3, 0.0, 1.0);
            builder.pop();
        }

        public static void reload() {
            debugMode = (Boolean)CommonConfig.COMMON.debugMode.get();
            homeRadius = (Integer)CommonConfig.COMMON.homeRadius.get();
            dfdBabyChance = (Double)CommonConfig.COMMON.dfdBabyChance.get();
        }
    }
}

