/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util;

import WolfShotz.Wyrmroost.Wyrmroost;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModUtils {
    public static final Logger L = LogManager.getLogger((String)"wyrmroost");

    private ModUtils() {
    }

    public static Item.Properties itemBuilder() {
        return new Item.Properties().func_200916_a(Wyrmroost.ITEM_GROUP);
    }

    public static Block.Properties blockBuilder(Material material) {
        Block.Properties properties = Block.Properties.func_200945_a((Material)material);
        if (material == Material.field_151575_d) {
            properties.harvestTool(ToolType.AXE).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a);
        } else if (material == Material.field_151576_e) {
            properties.harvestTool(ToolType.PICKAXE);
        } else if (material == Material.field_151595_p) {
            properties.harvestTool(ToolType.SHOVEL).func_200947_a(SoundType.field_185855_h);
        }
        return properties;
    }

    public static ClientWorld getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static ServerWorld getServerWorld(PlayerEntity player) {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(player.field_71093_bK);
    }

    public static <T extends IForgeRegistryEntry<T>> Set<T> getRegistryEntries(DeferredRegister<T> registry) {
        return registry.getEntries().stream().map(RegistryObject::get).collect(Collectors.toSet());
    }

    public static ItemStack getHeldStack(PlayerEntity player, Item item) {
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        return item == main.func_77973_b() ? main : (item == off.func_77973_b() ? off : main);
    }

    @Nullable
    public static <T extends Entity> EntityType<T> getTypeByString(@Nonnull String key) {
        return EntityType.func_220327_a((String)key).orElse(null);
    }

    public static boolean isBoxSafe(AxisAlignedBB aabb, World world) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = MathHelper.func_76128_c((double)aabb.field_72340_a); x < MathHelper.func_76128_c((double)aabb.field_72336_d); ++x) {
            for (int y = MathHelper.func_76143_f((double)aabb.field_72338_b); y < MathHelper.func_76128_c((double)aabb.field_72337_e); ++y) {
                for (int z = MathHelper.func_76128_c((double)aabb.field_72339_c); z < MathHelper.func_76128_c((double)aabb.field_72334_f); ++z) {
                    if (!world.func_180495_p((BlockPos)pos.func_181079_c(x, y, z)).func_200132_m()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static ITextComponent appendableTextTranslation(String ... strings) {
        TranslationTextComponent translation = new TranslationTextComponent(strings[0], new Object[0]);
        for (int i = 1; i < strings.length; ++i) {
            translation.func_150257_a((ITextComponent)new TranslationTextComponent(strings[i], new Object[0]));
        }
        return translation;
    }

    public static void putBlockPos(CompoundNBT nbt, BlockPos pos, String key) {
        nbt.func_74783_a(key, new int[]{pos.func_177956_o(), pos.func_177956_o(), pos.func_177952_p()});
    }

    public static BlockPos getBlockPos(CompoundNBT nbt, String key) {
        int[] poses = nbt.func_74759_k(key);
        return new BlockPos(poses[0], poses[1], poses[2]);
    }

    public static String replaceFirst(String string, String replacing, String replaceWith) {
        return Pattern.compile(replacing, 16).matcher(string).replaceFirst(replaceWith);
    }
}

