/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class QuikMaths {
    public static final float PI = (float)Math.PI;

    public static double nextPseudoDouble(Random rand) {
        return 2.0 * rand.nextDouble() - 1.0;
    }

    public static Vec3d calculateYawAngle(float amount, double xOffset, double zOffset) {
        return new Vec3d(xOffset, 0.0, zOffset).func_178785_b(-amount * ((float)Math.PI / 180));
    }

    public static double getSpaceDistSq(double sourceX, double targetX, double sourceY, double targetY, double sourceZ, double targetZ) {
        double x = targetX - sourceX;
        double y = targetY - sourceY;
        double z = targetZ - sourceZ;
        return x * x + y * y + z * z;
    }

    public static float getSpaceDistSq(float sourceX, float targetX, float sourceY, float targetY, float sourceZ, float targetZ) {
        float x = targetX - sourceX;
        float y = targetY - sourceY;
        float z = targetZ - sourceZ;
        return x * x + y * y + z * z;
    }

    public static double getAngle(double x1, double x2, double z1, double z2) {
        return Math.atan2(z2 - z1, x2 - x1) * 57.29577951308232 + 90.0;
    }

    public static RayTraceResult rayTrace(World world, PlayerEntity player, double range, boolean targetTamed) {
        RayTraceContext.FluidMode FLUID_MODE = RayTraceContext.FluidMode.NONE;
        RayTraceContext.BlockMode BLOCK_MODE = RayTraceContext.BlockMode.COLLIDER;
        Vec3d EYES_POSITION = player.func_174824_e(1.0f);
        Vec3d LOOK_DIRECTION = player.func_70676_i(1.0f);
        Vec3d endOfLook = EYES_POSITION.func_72441_c(LOOK_DIRECTION.field_72450_a * range, LOOK_DIRECTION.field_72448_b * range, LOOK_DIRECTION.field_72449_c * range);
        BlockRayTraceResult targetedBlock = world.func_217299_a(new RayTraceContext(EYES_POSITION, endOfLook, BLOCK_MODE, FLUID_MODE, (Entity)player));
        double collisionDistanceSQ = range * range;
        if (targetedBlock.func_216346_c() == RayTraceResult.Type.BLOCK) {
            collisionDistanceSQ = targetedBlock.func_216347_e().func_72436_e(EYES_POSITION);
            endOfLook = targetedBlock.func_216347_e();
        }
        Vec3d endOfLookDelta = endOfLook.func_178788_d(EYES_POSITION);
        AxisAlignedBB searchBox = player.func_174813_aQ().func_72321_a(endOfLookDelta.field_72450_a, endOfLookDelta.field_72448_b, endOfLookDelta.field_72449_c).func_186662_g(1.0);
        List nearbyEntities = world.func_175674_a((Entity)player, searchBox, e -> EntityPredicates.field_180132_d.test(e) && !e.equals((Object)player.func_184187_bx()));
        Entity closestEntityHit = null;
        double closestEntityDistanceSQ = Double.MAX_VALUE;
        for (Entity entity : nearbyEntities) {
            double distanceSQ;
            TameableEntity tamedEntity;
            if (!entity.func_70067_L() || entity == player.func_184187_bx() || !targetTamed && entity instanceof TameableEntity && (tamedEntity = (TameableEntity)entity).func_152114_e((LivingEntity)player)) continue;
            float collisionBorderSize = entity.func_70111_Y();
            AxisAlignedBB axisAlignedBB = entity.func_174813_aQ().func_186662_g((double)collisionBorderSize);
            Optional movingObjectPosition = axisAlignedBB.func_216365_b(EYES_POSITION, endOfLook);
            if (axisAlignedBB.func_72318_a(endOfLook)) {
                double d = !movingObjectPosition.isPresent() ? EYES_POSITION.func_72436_e(endOfLook) : EYES_POSITION.func_72436_e((Vec3d)movingObjectPosition.get());
                distanceSQ = d;
                if (!(distanceSQ <= closestEntityDistanceSQ)) continue;
                closestEntityDistanceSQ = distanceSQ;
                closestEntityHit = entity;
                continue;
            }
            if (!movingObjectPosition.isPresent() || !((distanceSQ = EYES_POSITION.func_72436_e((Vec3d)movingObjectPosition.get())) <= closestEntityDistanceSQ)) continue;
            closestEntityDistanceSQ = distanceSQ;
            closestEntityHit = entity;
        }
        if (closestEntityDistanceSQ <= collisionDistanceSQ && closestEntityHit != null) {
            return new EntityRayTraceResult(closestEntityHit, closestEntityHit.func_213303_ch());
        }
        return targetedBlock;
    }
}

