/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util.data;

import WolfShotz.Wyrmroost.registry.WRBlocks;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.util.ModUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.EntityFlagsPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.ValidationResults;
import net.minecraft.world.storage.loot.conditions.EntityHasProperty;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.Smelt;

public class LootTables
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = ImmutableList.of((Object)Pair.of(BlockLoot::new, (Object)LootParameterSets.field_216267_h), (Object)Pair.of(EntityLoot::new, (Object)LootParameterSets.field_216263_d));

    public LootTables(DataGenerator gen) {
        super(gen);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return this.tables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationResults validationresults) {
    }

    public static class EntityLoot
    extends EntityLootTables {
        private static final EntityPredicate.Builder ON_FIRE = EntityPredicate.Builder.func_203996_a().func_217987_a(EntityFlagsPredicate.Builder.func_217967_a().func_217968_a(Boolean.valueOf(true)).func_217966_b());
        private static final LootFunction.Builder<?> FIRE_CONDITION = Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)ON_FIRE));
        private final Map<EntityType<?>, LootTable.Builder> lootTables = Maps.newHashMap();

        private static LootPool.Builder lootTable() {
            return LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1));
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.addTables();
            for (EntityType<?> entity : this.getKnownEntities()) {
                if (!this.lootTables.containsKey(entity)) {
                    if (entity.func_220339_d() == EntityClassification.MISC) continue;
                    throw new IllegalArgumentException(String.format("Missing Loottable for entry: '%s'", entity.getRegistryName()));
                }
                consumer.accept(entity.func_220348_g(), this.lootTables.remove(entity));
            }
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ModUtils.getRegistryEntries(WREntities.ENTITIES);
        }

        public void registerEmptyTables(EntityType<?> ... types) {
            for (EntityType<?> type : types) {
                ModUtils.L.warn("Registering EMPTY Loottable for: '{}'", (Object)type.getRegistryName());
                this.func_218582_a(type, LootTable.func_216119_b());
            }
        }

        protected void func_218582_a(EntityType<?> type, LootTable.Builder table) {
            this.lootTables.put(type, table);
        }

        private static LootingEnchantBonus.Builder looting(float min, float max) {
            return LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)min, (float)max));
        }

        private static StandaloneLootEntry.Builder<?> item(IItemProvider itemIn, float minIn, float maxIn) {
            return ItemLootEntry.func_216168_a((IItemProvider)itemIn).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)minIn, (float)maxIn)));
        }

        private static StandaloneLootEntry.Builder<?> item(IItemProvider itemIn, int amount) {
            return ItemLootEntry.func_216168_a((IItemProvider)itemIn).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)amount)));
        }

        private static LootPool.Builder meat(IItemProvider itemIn, int minAmount, int maxAmount, int lootingMin, int lootingMax) {
            return EntityLoot.lootTable().func_216045_a((LootEntry.Builder)EntityLoot.item(itemIn, minAmount, maxAmount).func_212841_b_(FIRE_CONDITION).func_212841_b_((ILootFunction.IBuilder)EntityLoot.looting(lootingMin, lootingMax)));
        }

        protected void addTables() {
            this.registerEmptyTables((EntityType)WREntities.SILVER_GLIDER.get(), (EntityType)WREntities.BUTTERFLY_LEVIATHAN.get());
            this.func_218582_a((EntityType)WREntities.MINUTUS.get(), LootTable.func_216119_b().func_216040_a(EntityLoot.lootTable().func_216045_a((LootEntry.Builder)EntityLoot.item((IItemProvider)WRItems.MINUTUS.get(), 1).func_212841_b_(FIRE_CONDITION))));
            this.func_218582_a((EntityType)WREntities.OVERWORLD_DRAKE.get(), LootTable.func_216119_b().func_216040_a(EntityLoot.lootTable().func_216045_a((LootEntry.Builder)EntityLoot.item((IItemProvider)Items.field_151116_aA, 1.0f, 16.0f).func_212841_b_((ILootFunction.IBuilder)EntityLoot.looting(1.0f, 4.0f)))).func_216040_a(EntityLoot.meat((IItemProvider)WRItems.COMMON_MEAT_RAW.get(), 2, 6, 1, 4)).func_216040_a(EntityLoot.lootTable().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)WRItems.DRAKE_BACKPLATE.get()))).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.65f, (float)0.03f))));
            this.func_218582_a((EntityType)WREntities.ROOSTSTALKER.get(), LootTable.func_216119_b().func_216040_a(EntityLoot.lootTable().func_216045_a((LootEntry.Builder)EntityLoot.item((IItemProvider)Items.field_151074_bl, 0.0f, 4.0f).func_212841_b_((ILootFunction.IBuilder)EntityLoot.looting(1.0f, 3.0f)))).func_216040_a(EntityLoot.meat((IItemProvider)WRItems.LOWTIER_MEAT_RAW.get(), 0, 2, 1, 2)));
            this.func_218582_a((EntityType)WREntities.DRAGON_FRUIT_DRAKE.get(), LootTable.func_216119_b().func_216040_a(EntityLoot.meat((IItemProvider)WRItems.LOWTIER_MEAT_RAW.get(), 1, 2, 0, 2)));
            this.func_218582_a((EntityType)WREntities.CANARI_WYVERN.get(), LootTable.func_216119_b().func_216040_a(EntityLoot.lootTable().func_216045_a((LootEntry.Builder)EntityLoot.item((IItemProvider)Items.field_151008_G, 0.0f, 3.0f).func_212841_b_((ILootFunction.IBuilder)EntityLoot.looting(0.0f, 2.0f)))).func_216040_a(EntityLoot.meat((IItemProvider)WRItems.COMMON_MEAT_RAW.get(), 0, 2, 0, 2)));
            this.func_218582_a((EntityType)WREntities.SILVER_GLIDER.get(), LootTable.func_216119_b().func_216040_a(EntityLoot.meat((IItemProvider)WRItems.LOWTIER_MEAT_RAW.get(), 1, 4, 2, 3)));
        }
    }

    public static class BlockLoot
    extends BlockLootTables {
        public static final LootFunction.Builder<?> FORTUNE = ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t);
        public final Map<Block, LootTable.Builder> field_218581_i = Maps.newHashMap();

        protected void addTables() {
            this.registerOre((Block)WRBlocks.BLUE_GEODE_ORE.get(), (Item)WRItems.BLUE_GEODE.get());
            this.registerOre((Block)WRBlocks.RED_GEODE_ORE.get(), (Item)WRItems.RED_GEODE.get());
            this.registerOre((Block)WRBlocks.PURPLE_GEODE_ORE.get(), (Item)WRItems.PURPLE_GEODE.get());
            for (Block block : this.getKnownBlocks()) {
                if (this.field_218581_i.containsKey(block) || block.func_220068_i() == net.minecraft.world.storage.loot.LootTables.field_186419_a) continue;
                this.func_218492_c(block);
            }
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.addTables();
            for (Block block : this.getKnownBlocks()) {
                ResourceLocation loot = block.func_220068_i();
                if (loot == net.minecraft.world.storage.loot.LootTables.field_186419_a) continue;
                if (!this.field_218581_i.containsKey(block)) {
                    throw new IllegalStateException(String.format("Missing loottable '%s' for '%s', How the fuck did this happen?", loot, Registry.field_212618_g.func_177774_c((Object)block)));
                }
                consumer.accept(loot, this.field_218581_i.remove(block));
            }
            if (!this.field_218581_i.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + this.field_218581_i.keySet());
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return ModUtils.getRegistryEntries(WRBlocks.BLOCKS);
        }

        private void registerOre(Block ore, Item output) {
            this.func_218522_a(ore, block -> BlockLoot.func_218476_a((Block)block, (Item)output));
        }

        protected void func_218507_a(Block blockIn, LootTable.Builder table) {
            this.field_218581_i.put(blockIn, table);
        }
    }
}

