/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util.data;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.content.items.CustomSpawnEggItem;
import WolfShotz.Wyrmroost.registry.WRBlocks;
import WolfShotz.Wyrmroost.registry.WRFluids;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.util.ModUtils;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.TieredItem;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class Models {

    public static class ItemModels
    extends ItemModelProvider {
        final ExistingFileHelper theGOODExistingFileHelper;
        private final List<Item> REGISTERED = Lists.newArrayList();
        private final List<String> MISSING_TEXTURES = Lists.newArrayList();

        public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "wyrmroost", existingFileHelper);
            this.theGOODExistingFileHelper = existingFileHelper;
        }

        private static ResourceLocation resource(String path) {
            return Wyrmroost.rl("item/" + path);
        }

        public ItemModelBuilder item(Item item) {
            ItemModelBuilder builder = this.itemBare(item);
            String parent = item instanceof TieredItem ? "item/handheld" : "item/generated";
            builder.parent((ModelFile)new ModelFile.UncheckedModelFile(parent));
            ResourceLocation texture = ItemModels.resource(item.getRegistryName().func_110623_a());
            if (!this.theGOODExistingFileHelper.exists(texture, ResourcePackType.CLIENT_RESOURCES, ".png", "textures")) {
                this.MISSING_TEXTURES.add(texture.func_110623_a().replace("item/", ""));
            } else {
                builder.texture("layer0", texture);
            }
            return builder;
        }

        public ItemModelBuilder itemBare(Item item) {
            this.REGISTERED.add(item);
            return (ItemModelBuilder)this.getBuilder(item.getRegistryName().func_110623_a());
        }

        protected void registerModels() {
            ((ItemModelBuilder)this.itemBare((Item)WRItems.DRAGON_EGG.get()).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).transforms().transform(ModelBuilder.Perspective.GUI).rotation(160.0f, 8.0f, 30.0f).translation(21.0f, 6.0f, 0.0f).scale(1.5f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(180.0f, 10.0f, 4.0f).translation(14.0f, 15.0f, -10.0f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(180.0f, 10.0f, 4.0f).translation(-7.0f, 17.0f, -13.0f).end().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(253.0f, 65.0f, 0.0f).translation(8.0f, 2.0f, 10.0f).scale(0.75f).end().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(253.0f, 65.0f, 0.0f).translation(3.0f, 13.0f, 7.0f).scale(0.75f).end().transform(ModelBuilder.Perspective.GROUND).rotation(180.0f, 0.0f, 0.0f).translation(4.0f, 8.0f, -5.0f).scale(0.55f).end();
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("minutus_alive")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/generated")))).texture("layer0", ItemModels.resource("minutus_alive"));
            this.item((Item)WRItems.MINUTUS.get()).override().predicate(Wyrmroost.rl("isalive"), 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(ItemModels.resource("minutus_alive")));
            this.item((Item)WRItems.DRAGON_STAFF.get()).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"));
            for (CustomSpawnEggItem item : CustomSpawnEggItem.EGG_TYPES) {
                this.itemBare(item).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/template_spawn_egg")));
            }
            for (Block block : ModUtils.getRegistryEntries(WRBlocks.BLOCKS)) {
                if (this.REGISTERED.contains(block.func_199767_j()) || block instanceof FlowingFluidBlock) continue;
                ResourceLocation path = block.getRegistryName();
                this.itemBare(block.func_199767_j()).parent((ModelFile)new ModelFile.UncheckedModelFile(path.func_110624_b() + ":block/" + path.func_110623_a()));
            }
            for (Fluid fluid : ModUtils.getRegistryEntries(WRFluids.FLUIDS)) {
                this.itemBare(fluid.func_204524_b()).parent((ModelFile)new ModelFile.UncheckedModelFile("forge:item/bucket"));
            }
            ModUtils.getRegistryEntries(WRItems.ITEMS).stream().filter(e -> !this.REGISTERED.contains(e)).forEach(this::item);
            if (!this.MISSING_TEXTURES.isEmpty()) {
                ModUtils.L.error("Items are missing Textures! Models will not be registered: {}", (Object)this.MISSING_TEXTURES.toString());
            }
        }

        public String func_200397_b() {
            return "Wyrmroost Item Models";
        }
    }

    public static class BlockModels
    extends BlockStateProvider {
        public final ExistingFileHelper theGOODexistingFileHelper;
        private final List<String> MISSING_TEXTURES = Lists.newArrayList();

        public BlockModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "wyrmroost", existingFileHelper);
            this.theGOODexistingFileHelper = existingFileHelper;
        }

        protected void registerStatesAndModels() {
            for (Block block : ModUtils.getRegistryEntries(WRBlocks.BLOCKS)) {
                if (this.registeredBlocks.containsKey(block) || block instanceof FlowingFluidBlock) continue;
                ResourceLocation name = block.getRegistryName();
                if (!this.theGOODexistingFileHelper.exists(new ResourceLocation(name.func_110624_b(), "block/" + name.func_110623_a()), ResourcePackType.CLIENT_RESOURCES, ".png", "textures")) {
                    this.MISSING_TEXTURES.add(name.func_110623_a().replace("block/", ""));
                    continue;
                }
                this.simpleBlock(block);
            }
            if (!this.MISSING_TEXTURES.isEmpty()) {
                ModUtils.L.error("Blocks are missing Textures! Models will not be registered: {}", (Object)this.MISSING_TEXTURES.toString());
            }
        }

        protected void axisBlock(RotatedPillarBlock block) {
            this.axisBlock(block, this.blockTexture((Block)block), new ResourceLocation(this.blockTexture((Block)block) + "_top"));
        }

        protected void simpleBlock(Block block, String path) {
            this.simpleBlock(block, (ModelFile)this.cubeAll(block.getRegistryName().func_110623_a(), Wyrmroost.rl("block/" + path)));
        }

        public BlockModelBuilder cubed(Block block) {
            return (BlockModelBuilder)this.cubeAll(block.getRegistryName().func_110623_a(), this.blockTexture(block));
        }
    }
}

