/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util.entityutils.ai.goals;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EntityPredicates;

public class CommonGoalWrappers {
    public static LookAtGoal lookAt(AbstractDragonEntity entity, Class<LivingEntity> toLookat, float distance) {
        return new LookAtGoal((MobEntity)entity, toLookat, distance){

            public boolean func_75250_a() {
                return super.func_75250_a() && !this.field_75332_b.func_184188_bt().contains(this.field_75334_a);
            }
        };
    }

    public static LookAtGoal lookAt(AbstractDragonEntity entity, float distance) {
        return CommonGoalWrappers.lookAt(entity, LivingEntity.class, distance);
    }

    public static TemptGoal nonTamedTemptGoal(AbstractDragonEntity dragon, double speed, boolean scaredByMovement, Ingredient temptedItems) {
        return new TemptGoal((CreatureEntity)dragon, speed, scaredByMovement, temptedItems){

            public boolean func_75250_a() {
                return !((AbstractDragonEntity)this.field_75284_a).func_70909_n() && super.func_75250_a();
            }
        };
    }

    public static FollowParentGoal followParent(final AbstractDragonEntity animal, double speed) {
        FollowParentGoal goal = new FollowParentGoal((AnimalEntity)animal, speed){
            {
                super(x0, x1);
                this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            }

            public boolean func_75250_a() {
                return !animal.func_70909_n() && super.func_75250_a();
            }
        };
        return goal;
    }

    public static FollowOwnerGoal followOwner(AbstractDragonEntity dragon, double speed, float minDist, float maxDist) {
        return new FollowOwnerGoal(dragon, speed, minDist, maxDist){

            public boolean func_75250_a() {
                if (this.field_75338_d.func_70608_bn() || ((AbstractDragonEntity)this.field_75338_d).getHomePos().isPresent()) {
                    return false;
                }
                return super.func_75250_a();
            }
        };
    }

    public static <T extends LivingEntity> NonTamedTargetGoal<T> nonTamedTarget(final TameableEntity tameable, Class<T> targetClass, final boolean asChild, boolean checkSight, Predicate<LivingEntity> targets) {
        return new NonTamedTargetGoal<T>(tameable, targetClass, checkSight, targets){

            public boolean func_75250_a() {
                return (!asChild || tameable.func_70631_g_()) && super.func_75250_a();
            }
        };
    }

    public static <T extends LivingEntity> NonTamedTargetGoal<T> nonTamedTarget(TameableEntity tameable, Class<T> targetClass, boolean asChild) {
        return CommonGoalWrappers.nonTamedTarget(tameable, targetClass, asChild, true, EntityPredicates.field_188444_d::test);
    }

    public static <T extends LivingEntity> AvoidEntityGoal<T> nonTamedAvoidGoal(final TameableEntity tameable, Class<T> avoiding, Predicate<LivingEntity> filter, float distance, float nearSpeed, float farSpeed) {
        return new AvoidEntityGoal<T>((CreatureEntity)tameable, avoiding, filter, distance, nearSpeed, farSpeed, EntityPredicates.field_188444_d::test){

            public boolean func_75250_a() {
                return !tameable.func_70909_n() && super.func_75250_a();
            }
        };
    }

    public static <T extends LivingEntity> AvoidEntityGoal<T> nonTamedAvoidGoal(TameableEntity tameable, Class<T> avoiding, float distance, float speed) {
        return CommonGoalWrappers.nonTamedAvoidGoal(tameable, avoiding, e -> true, distance, speed, speed * 1.5f);
    }
}

