/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util.entityutils.ai.goals;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.util.QuikMaths;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNodeType;

public class FlyerFollowOwnerGoal
extends Goal {
    private final AbstractDragonEntity dragon;
    private final double minDist;
    private final double maxDist;
    private final double maxHeight;
    private final boolean orbitOverHead;
    private LivingEntity owner;
    private float oldWaterCost;
    private int timeToRecalcPath;

    public FlyerFollowOwnerGoal(AbstractDragonEntity dragon, double minDist, double maxDist, double maxHeight, boolean orbitOverHead) {
        this.dragon = dragon;
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.maxHeight = maxHeight;
        this.orbitOverHead = orbitOverHead;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        boolean tooClose;
        if (this.dragon.getHomePos().isPresent()) {
            return false;
        }
        LivingEntity preOwner = this.dragon.func_70902_q();
        if (this.dragon.func_70906_o() || preOwner == null || preOwner.func_175149_v()) {
            return false;
        }
        this.owner = preOwner;
        double minDistSq = this.minDist * this.minDist;
        boolean bl = tooClose = this.dragon.func_70068_e((Entity)preOwner) < minDistSq;
        if (this.dragon.isFlying()) {
            tooClose = this.dragon.func_195048_a(preOwner.func_213303_ch().func_72441_c(0.0, this.maxHeight, 0.0)) < minDistSq;
        }
        return !tooClose;
    }

    public boolean func_75253_b() {
        if (this.dragon.func_70906_o() || this.owner == null) {
            return false;
        }
        double maxDistSq = this.maxDist * this.maxDist;
        if (this.dragon.isFlying()) {
            return this.dragon.func_195048_a(this.owner.func_213303_ch().func_72441_c(0.0, this.maxHeight, 0.0)) > maxDistSq;
        }
        return !this.dragon.func_70661_as().func_75500_f() && this.dragon.func_70068_e((Entity)this.owner) > maxDistSq;
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dragon.func_184643_a(PathNodeType.WATER);
        this.dragon.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.dragon.func_70661_as().func_75499_g();
        this.dragon.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        if (this.dragon.func_70906_o()) {
            return;
        }
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = 10;
        if (this.dragon.field_70163_u < this.owner.field_70163_u + this.maxDist * 2.0) {
            this.dragon.setFlying(true);
        }
        if (this.dragon.isFlying()) {
            if (this.dragon.func_195048_a(this.owner.func_213303_ch().func_72441_c(0.0, this.maxHeight, 0.0)) > 3.0 * (this.minDist * this.minDist)) {
                double xOff = QuikMaths.nextPseudoDouble(this.dragon.func_70681_au()) * 2.0;
                double zOff = QuikMaths.nextPseudoDouble(this.dragon.func_70681_au()) * 2.0;
                this.dragon.tryTeleportToPos(this.owner.func_180425_c().func_177963_a(xOff, this.maxHeight, zOff));
            } else if (!this.dragon.func_70605_aq().func_75640_a()) {
                this.dragon.func_70671_ap().func_75650_a(this.owner.field_70165_t, this.owner.field_70163_u + this.maxHeight, this.owner.field_70161_v, 10.0f, (float)this.dragon.func_70646_bf());
                this.dragon.func_70605_aq().func_75642_a(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, 1.0);
            }
        } else {
            this.dragon.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.dragon.func_70646_bf());
            if (this.dragon.func_70068_e((Entity)this.owner) > 1.5 * (this.minDist * this.minDist)) {
                this.dragon.tryTeleportToOwner();
            } else {
                this.dragon.func_70605_aq().func_75642_a(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, 1.0);
            }
        }
    }
}

