/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util.entityutils.ai.goals;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.util.QuikMaths;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.Vec3d;

public class FlyerWanderGoal
extends Goal {
    private final AbstractDragonEntity dragon;
    private final boolean sleepTempted;

    public FlyerWanderGoal(AbstractDragonEntity dragon, boolean sleepTempted) {
        this.dragon = dragon;
        this.sleepTempted = sleepTempted;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.dragon.func_70608_bn()) {
            return false;
        }
        if (!this.dragon.func_184188_bt().isEmpty()) {
            return false;
        }
        if (this.dragon.isFlying()) {
            MovementController moveController = this.dragon.func_70605_aq();
            double euclid = QuikMaths.getSpaceDistSq(this.dragon.field_70165_t, moveController.func_179917_d(), this.dragon.field_70163_u, moveController.func_179919_e(), this.dragon.field_70161_v, moveController.func_179918_f());
            return euclid < 1.0 || euclid > 3068.0;
        }
        return this.dragon.func_70681_au().nextInt(120) == 0;
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        Vec3d vec3d = this.getPosition();
        if (vec3d == null) {
            return;
        }
        if (this.dragon.isFlying()) {
            this.dragon.func_70605_aq().func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
        } else {
            this.dragon.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
        }
    }

    public Vec3d getPosition() {
        if (this.dragon.isFlying()) {
            Random rand = this.dragon.func_70681_au();
            double x = this.dragon.field_70165_t + QuikMaths.nextPseudoDouble(rand) * 20.0;
            double y = this.dragon.field_70163_u + QuikMaths.nextPseudoDouble(rand) * 16.0;
            double z = this.dragon.field_70161_v + QuikMaths.nextPseudoDouble(rand) * 20.0;
            if (this.sleepTempted && !this.dragon.field_70170_p.func_72935_r()) {
                y = Math.max(-Math.abs(y), 0.0);
            }
            if (y > 175.0) {
                y -= 25.0;
            }
            return new Vec3d(x, y, z);
        }
        return RandomPositionGenerator.func_75463_a((CreatureEntity)this.dragon, (int)10, (int)7);
    }
}

