/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util.entityutils.ai.goals;

import WolfShotz.Wyrmroost.content.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.IAnimatedObject;
import WolfShotz.Wyrmroost.util.network.NetworkUtils;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class GrazeGoal
extends Goal {
    private static final Predicate<BlockState> IS_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150349_c);
    private final AbstractDragonEntity herbivore;
    private final World world;
    private int eatingGrassTimer;
    private int blockPosOffset;
    private Animation animation;

    public GrazeGoal(AbstractDragonEntity herbivoreIn, int blockPosOffset, Animation animation) {
        this.herbivore = herbivoreIn;
        this.world = herbivoreIn.field_70170_p;
        this.blockPosOffset = blockPosOffset;
        this.animation = animation;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public GrazeGoal(AbstractDragonEntity herbivoreIn, Animation animation) {
        this(herbivoreIn, 0, animation);
    }

    public GrazeGoal(AbstractDragonEntity herbivoreIn) {
        this(herbivoreIn, 0, IAnimatedObject.NO_ANIMATION);
    }

    public boolean func_75250_a() {
        if (this.herbivore.func_70638_az() != null) {
            return false;
        }
        if (this.herbivore.func_184207_aI()) {
            return false;
        }
        if (this.herbivore.func_70681_au().nextInt(this.herbivore.func_70631_g_() ? 50 : 1000) != 0) {
            return false;
        }
        BlockPos blockpos = new BlockPos((Entity)this.herbivore);
        int blockPosOffset = this.herbivore.func_70631_g_() ? this.blockPosOffset / 2 : this.blockPosOffset;
        BlockPos offsetPos = blockpos.func_177967_a(this.herbivore.func_174811_aO(), blockPosOffset).func_177977_b();
        return IS_GRASS.test(this.world.func_180495_p(new BlockPos((Entity)this.herbivore))) || this.world.func_180495_p(offsetPos).func_177230_c() == Blocks.field_196658_i;
    }

    public void func_75249_e() {
        this.eatingGrassTimer = 40;
        this.world.func_72960_a((Entity)this.herbivore, (byte)10);
        this.herbivore.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.eatingGrassTimer = 0;
    }

    public boolean func_75253_b() {
        return this.eatingGrassTimer > 0;
    }

    public void func_75246_d() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.eatingGrassTimer == 4) {
            BlockPos blockpos = new BlockPos((Entity)this.herbivore).func_177967_a(this.herbivore.func_174811_aO(), this.blockPosOffset);
            if (IS_GRASS.test(this.world.func_180495_p(blockpos))) {
                if (ForgeEventFactory.getMobGriefingEvent((World)this.world, (Entity)this.herbivore)) {
                    this.world.func_175655_b(blockpos, false);
                }
                this.herbivore.func_70615_aA();
                NetworkUtils.sendAnimationPacket(this.herbivore, this.animation);
            } else {
                BlockPos blockpos1 = blockpos.func_177977_b();
                if (this.world.func_180495_p(blockpos1).func_177230_c() == Blocks.field_196658_i) {
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.world, (Entity)this.herbivore)) {
                        this.world.func_217379_c(2001, blockpos1, Block.func_196246_j((BlockState)Blocks.field_196658_i.func_176223_P()));
                        this.world.func_180501_a(blockpos1, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                    this.herbivore.func_70615_aA();
                    NetworkUtils.sendAnimationPacket(this.herbivore, this.animation);
                }
            }
        }
    }
}

