/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util.entityutils.client.animation;

import WolfShotz.Wyrmroost.util.entityutils.client.animation.Animation;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.IAnimatedObject;
import WolfShotz.Wyrmroost.util.entityutils.client.model.AdvancedRendererModel;
import WolfShotz.Wyrmroost.util.entityutils.client.model.BoxPosCache;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;

public class ModelAnimator {
    private int tempTick = 0;
    private int prevTempTick;
    private boolean correctAnimation = false;
    private IAnimatedObject entity;
    private boolean keyFrameInverted = false;
    private HashMap<AdvancedRendererModel, BoxPosCache> boxPosCache = new HashMap();
    private HashMap<AdvancedRendererModel, BoxPosCache> prevPosCache = new HashMap();

    private ModelAnimator() {
    }

    public static ModelAnimator create() {
        return new ModelAnimator();
    }

    public IAnimatedObject getEntity() {
        return this.entity;
    }

    public void update(IAnimatedObject entity) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnimation = false;
        this.entity = entity;
        this.boxPosCache.clear();
        this.prevPosCache.clear();
    }

    public boolean setAnimation(Animation animation) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnimation = this.entity.getAnimation() == animation;
        return this.correctAnimation;
    }

    public void startKeyframe(int duration) {
        if (this.correctAnimation) {
            this.prevTempTick = this.tempTick;
            this.tempTick += duration;
        }
    }

    public void invertKeyframe(boolean invert) {
        this.keyFrameInverted = invert;
    }

    public void setStaticKeyframe(int duration) {
        this.startKeyframe(duration);
        this.endKeyframe(true);
    }

    public void resetKeyframe(int duration) {
        this.startKeyframe(duration);
        this.endKeyframe();
    }

    public void rotate(AdvancedRendererModel box, float x, float y, float z) {
        if (this.keyFrameInverted) {
            x = -x;
            y = -y;
            z = -z;
        }
        if (this.correctAnimation) {
            this.getPosCache(box).addRotation(x, y, z);
        }
    }

    public void move(AdvancedRendererModel box, float x, float y, float z) {
        if (this.keyFrameInverted) {
            x = -x;
            y = -y;
            z = -z;
        }
        if (this.correctAnimation) {
            this.getPosCache(box).addOffset(x, y, z);
        }
    }

    private BoxPosCache getPosCache(AdvancedRendererModel box) {
        return this.boxPosCache.computeIfAbsent(box, b -> new BoxPosCache());
    }

    public void endKeyframe() {
        this.endKeyframe(false);
        this.keyFrameInverted = false;
    }

    private void endKeyframe(boolean stationary) {
        if (this.correctAnimation) {
            int animationTick = this.entity.getAnimationTick();
            if (animationTick >= this.prevTempTick && animationTick < this.tempTick) {
                if (stationary) {
                    for (AdvancedRendererModel box : this.prevPosCache.keySet()) {
                        BoxPosCache cache = this.prevPosCache.get((Object)box);
                        box.field_78795_f += cache.getRotationX();
                        box.field_78796_g += cache.getRotationY();
                        box.field_78808_h += cache.getRotationZ();
                        box.field_78800_c += cache.getOffsetX();
                        box.field_78797_d += cache.getOffsetY();
                        box.field_78798_e += cache.getOffsetZ();
                    }
                } else {
                    BoxPosCache cache;
                    float tick = ((float)(animationTick - this.prevTempTick) + Minecraft.func_71410_x().func_184121_ak()) / (float)(this.tempTick - this.prevTempTick);
                    float inc = MathHelper.func_76126_a((float)((float)((double)tick * Math.PI / 2.0)));
                    float dec = 1.0f - inc;
                    for (AdvancedRendererModel box : this.prevPosCache.keySet()) {
                        cache = this.prevPosCache.get((Object)box);
                        box.field_78795_f += dec * cache.getRotationX();
                        box.field_78796_g += dec * cache.getRotationY();
                        box.field_78808_h += dec * cache.getRotationZ();
                        box.field_78800_c += dec * cache.getOffsetX();
                        box.field_78797_d += dec * cache.getOffsetY();
                        box.field_78798_e += dec * cache.getOffsetZ();
                    }
                    for (AdvancedRendererModel box : this.boxPosCache.keySet()) {
                        cache = this.boxPosCache.get((Object)box);
                        box.field_78795_f += inc * cache.getRotationX();
                        box.field_78796_g += inc * cache.getRotationY();
                        box.field_78808_h += inc * cache.getRotationZ();
                        box.field_78800_c += inc * cache.getOffsetX();
                        box.field_78797_d += inc * cache.getOffsetY();
                        box.field_78798_e += inc * cache.getOffsetZ();
                    }
                }
            }
            if (!stationary) {
                this.prevPosCache.clear();
                this.prevPosCache.putAll(this.boxPosCache);
                this.boxPosCache.clear();
            }
        }
    }
}

