/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util.entityutils.client.model;

import WolfShotz.Wyrmroost.util.entityutils.client.animation.ModelAnimator;
import WolfShotz.Wyrmroost.util.entityutils.client.model.AdvancedRendererModel;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.Pair;

public class AdvancedLivingEntityModel<T extends Entity>
extends EntityModel<T> {
    public T entity;
    public float globalSpeed = 0.5f;
    private float movementScale = 1.0f;
    private final Map<String, Pair<Integer, Integer>> modelTextureMap = Maps.newHashMap();

    public void updateDefaultPose() {
        this.field_78092_r.stream().filter(AdvancedRendererModel.class::isInstance).forEach(model -> ((AdvancedRendererModel)((Object)model)).updateDefaultPose());
    }

    protected void setTextureOffset(String partName, int x, int y) {
        this.modelTextureMap.put(partName, (Pair<Integer, Integer>)Pair.of((Object)x, (Object)y));
    }

    public Pair<Integer, Integer> getTextureOffset(String partName) {
        return this.modelTextureMap.get(partName);
    }

    public void resetToDefaultPose() {
        this.field_78092_r.stream().filter(AdvancedRendererModel.class::isInstance).forEach(model -> ((AdvancedRendererModel)((Object)model)).resetToDefaultPose());
    }

    public void faceTarget(float yaw, float pitch, float rotationDivisor, AdvancedRendererModel ... boxes) {
        float actualRotationDivisor = rotationDivisor * (float)boxes.length;
        float yawAmount = yaw / 57.295776f / actualRotationDivisor;
        float pitchAmount = pitch / 57.295776f / actualRotationDivisor;
        AdvancedRendererModel[] var8 = boxes;
        int var9 = boxes.length;
        for (int var10 = 0; var10 < var9; ++var10) {
            AdvancedRendererModel box = var8[var10];
            box.field_78796_g += yawAmount;
            box.field_78795_f += pitchAmount;
        }
    }

    public void chainSwing(AdvancedRendererModel[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78796_g += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    public void chainWave(AdvancedRendererModel[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78795_f += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    public void chainFlap(AdvancedRendererModel[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78808_h += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    private float calculateChainRotation(float speed, float degree, float swing, float swingAmount, float offset, int boxIndex) {
        return MathHelper.func_76134_b((float)(swing * speed * this.movementScale + offset * (float)boxIndex)) * swingAmount * degree * this.movementScale;
    }

    private float calculateChainOffset(double rootOffset, AdvancedRendererModel ... boxes) {
        return (float)(rootOffset * Math.PI / (double)(2 * boxes.length));
    }

    public float getMovementScale() {
        return this.movementScale;
    }

    public void setMovementScale(float movementScale) {
        this.movementScale = movementScale;
    }

    public void walk(AdvancedRendererModel box, float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        box.walk(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void flap(AdvancedRendererModel box, float speed, float degree, boolean invert, float offset, float weight, float flap, float flapAmount) {
        box.flap(speed, degree, invert, offset, weight, flap, flapAmount);
    }

    public void swing(AdvancedRendererModel box, float speed, float degree, boolean invert, float offset, float weight, float swing, float swingAmount) {
        box.swing(speed, degree, invert, offset, weight, swing, swingAmount);
    }

    public void bob(AdvancedRendererModel box, float speed, float degree, boolean bounce, float f, float f1) {
        box.bob(speed, degree, bounce, f, f1);
    }

    public float moveBox(float speed, float degree, boolean bounce, float f, float f1) {
        return bounce ? -MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)(f * speed)) * f1 * degree)) : MathHelper.func_76126_a((float)(f * speed)) * f1 * degree - f1 * degree;
    }

    public void setRotateAngle(AdvancedRendererModel model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public void rotate(ModelAnimator animator, AdvancedRendererModel model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public void rotateMinus(ModelAnimator animator, AdvancedRendererModel model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x) - model.defaultRotationX, (float)Math.toRadians(y) - model.defaultRotationY, (float)Math.toRadians(z) - model.defaultRotationZ);
    }

    public void idleAnim(float frame) {
    }
}

