/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util.entityutils.client.model;

import WolfShotz.Wyrmroost.util.entityutils.client.model.AdvancedLivingEntityModel;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.ModelBox;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.Pair;

public class AdvancedRendererModel
extends RendererModel {
    public float defaultRotationX;
    public float defaultRotationY;
    public float defaultRotationZ;
    public float defaultOffsetX;
    public float defaultOffsetY;
    public float defaultOffsetZ;
    public float defaultPositionX;
    public float defaultPositionY;
    public float defaultPositionZ;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public int field_78803_o;
    public int field_78813_p;
    public boolean scaleChildren;
    private AdvancedLivingEntityModel<?> model;
    private AdvancedRendererModel parent;
    private int displayList;
    private boolean compiled;

    public AdvancedRendererModel(AdvancedLivingEntityModel<?> model, String name) {
        super(model, name);
        this.model = model;
    }

    public AdvancedRendererModel(AdvancedLivingEntityModel<?> model) {
        this(model, null);
    }

    public AdvancedRendererModel(AdvancedLivingEntityModel<?> model, int textureOffsetX, int textureOffsetY) {
        this(model);
        this.setTextureOffset(textureOffsetX, textureOffsetY);
    }

    public RendererModel addBox(String partName, float offX, float offY, float offZ, int width, int height, int depth) {
        partName = this.field_78802_n + "." + partName;
        Pair<Integer, Integer> textureOffset = this.model.getTextureOffset(partName);
        this.setTextureOffset((Integer)textureOffset.getLeft(), (Integer)textureOffset.getRight());
        this.field_78804_l.add(new ModelBox((RendererModel)this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, 0.0f).func_78244_a(partName));
        return this;
    }

    public RendererModel func_78789_a(float offX, float offY, float offZ, int width, int height, int depth) {
        this.field_78804_l.add(new ModelBox((RendererModel)this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, 0.0f));
        return this;
    }

    public RendererModel func_178769_a(float offX, float offY, float offZ, int width, int height, int depth, boolean mirrored) {
        this.field_78804_l.add(new ModelBox((RendererModel)this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, 0.0f, mirrored));
        return this;
    }

    public void func_78790_a(float offX, float offY, float offZ, int width, int height, int depth, float scaleFactor) {
        this.field_78804_l.add(new ModelBox((RendererModel)this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, scaleFactor));
    }

    public void setShouldScaleChildren(boolean scaleChildren) {
        this.scaleChildren = scaleChildren;
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScaleZ(float scaleZ) {
        this.scaleZ = scaleZ;
    }

    public void updateDefaultPose() {
        this.defaultRotationX = this.field_78795_f;
        this.defaultRotationY = this.field_78796_g;
        this.defaultRotationZ = this.field_78808_h;
        this.defaultOffsetX = this.field_82906_o;
        this.defaultOffsetY = this.field_82908_p;
        this.defaultOffsetZ = this.field_82907_q;
        this.defaultPositionX = this.field_78800_c;
        this.defaultPositionY = this.field_78797_d;
        this.defaultPositionZ = this.field_78798_e;
    }

    public void resetToDefaultPose() {
        this.field_78795_f = this.defaultRotationX;
        this.field_78796_g = this.defaultRotationY;
        this.field_78808_h = this.defaultRotationZ;
        this.field_82906_o = this.defaultOffsetX;
        this.field_82908_p = this.defaultOffsetY;
        this.field_82907_q = this.defaultOffsetZ;
        this.field_78800_c = this.defaultPositionX;
        this.field_78797_d = this.defaultPositionY;
        this.field_78798_e = this.defaultPositionZ;
    }

    public void func_78792_a(RendererModel child) {
        super.func_78792_a(child);
        if (child instanceof AdvancedRendererModel) {
            ((AdvancedRendererModel)child).setParent(this);
        }
    }

    public AdvancedRendererModel getParent() {
        return this.parent;
    }

    public void setParent(AdvancedRendererModel parent) {
        this.parent = parent;
    }

    public void parentedPostRender(float scale) {
        if (this.parent != null) {
            this.parent.parentedPostRender(scale);
        }
        this.func_78794_c(scale);
    }

    public void renderWithParents(float scale) {
        if (this.parent != null) {
            this.parent.renderWithParents(scale);
        }
        this.func_78785_a(scale);
    }

    public void func_78785_a(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            GlStateManager.pushMatrix();
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            GlStateManager.translatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
            GlStateManager.translatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
            if (this.field_78808_h != 0.0f) {
                GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.field_78796_g != 0.0f) {
                GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.field_78795_f != 0.0f) {
                GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f) {
                GlStateManager.scalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            }
            GlStateManager.callList((int)this.displayList);
            if (!(this.scaleChildren || this.scaleX == 1.0f && this.scaleY == 1.0f && this.scaleZ == 1.0f)) {
                GlStateManager.popMatrix();
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
                GlStateManager.translatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                if (this.field_78808_h != 0.0f) {
                    GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.field_78796_g != 0.0f) {
                    GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.field_78795_f != 0.0f) {
                    GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
            if (this.field_78805_m != null) {
                for (RendererModel childModel : this.field_78805_m) {
                    childModel.func_78785_a(scale);
                }
            }
            GlStateManager.popMatrix();
        }
    }

    private void compileDisplayList(float scale) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.newList((int)this.displayList, (int)4864);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        for (ModelBox box : this.field_78804_l) {
            box.func_178780_a(buffer, scale);
        }
        GlStateManager.endList();
        this.compiled = true;
    }

    public AdvancedLivingEntityModel<?> getModel() {
        return this.model;
    }

    private float calculateRotation(float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        float movementScale = this.model.getMovementScale();
        float rotation = MathHelper.func_76134_b((float)(f * speed * movementScale + offset)) * degree * movementScale * f1 + weight * f1;
        return invert ? -rotation : rotation;
    }

    public void walk(float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        this.field_78795_f += this.calculateRotation(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void flap(float speed, float degree, boolean invert, float offset, float weight, float flap, float flapAmount) {
        this.field_78808_h += this.calculateRotation(speed, degree, invert, offset, weight, flap, flapAmount);
    }

    public void swing(float speed, float degree, boolean invert, float offset, float weight, float swing, float swingAmount) {
        this.field_78796_g += this.calculateRotation(speed, degree, invert, offset, weight, swing, swingAmount);
    }

    public void bob(float speed, float degree, boolean bounce, float f, float f1) {
        float movementScale = this.model.getMovementScale();
        float bob = (float)(Math.sin(f * (speed *= movementScale)) * (double)f1 * (double)(degree *= movementScale) - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        this.field_78797_d += bob;
    }

    public AdvancedRendererModel setTextureOffset(int textureOffsetX, int textureOffsetY) {
        this.field_78803_o = textureOffsetX;
        this.field_78813_p = textureOffsetY;
        return this;
    }

    public void transitionTo(AdvancedRendererModel to, float timer, float maxTime) {
        this.field_78795_f += (to.field_78795_f - this.field_78795_f) / maxTime * timer;
        this.field_78796_g += (to.field_78796_g - this.field_78796_g) / maxTime * timer;
        this.field_78808_h += (to.field_78808_h - this.field_78808_h) / maxTime * timer;
        this.field_78800_c += (to.field_78800_c - this.field_78800_c) / maxTime * timer;
        this.field_78797_d += (to.field_78797_d - this.field_78797_d) / maxTime * timer;
        this.field_78798_e += (to.field_78798_e - this.field_78798_e) / maxTime * timer;
        this.field_82906_o += (to.field_82906_o - this.field_82906_o) / maxTime * timer;
        this.field_82908_p += (to.field_82908_p - this.field_82908_p) / maxTime * timer;
        this.field_82907_q += (to.field_82907_q - this.field_82907_q) / maxTime * timer;
    }
}

