/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util.entityutils.client.model;

import WolfShotz.Wyrmroost.util.entityutils.client.model.AdvancedLivingEntityModel;
import WolfShotz.Wyrmroost.util.entityutils.client.model.AdvancedRendererModel;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;

public class SocketRendererModel
extends AdvancedRendererModel {
    public SocketRendererModel(AdvancedLivingEntityModel model, String name) {
        super(model, name);
    }

    public SocketRendererModel(AdvancedLivingEntityModel model) {
        this(model, (String)null);
    }

    public SocketRendererModel(AdvancedLivingEntityModel model, int textureOffsetX, int textureOffsetY) {
        this(model);
        this.setTextureOffset(textureOffsetX, textureOffsetY);
    }

    public SocketRendererModel(SocketRendererModel modelRenderer) {
        super(modelRenderer.getModel(), modelRenderer.field_78803_o, modelRenderer.field_78813_p);
        this.field_78800_c = modelRenderer.field_78800_c;
        this.field_78797_d = modelRenderer.field_78797_d;
        this.field_78798_e = modelRenderer.field_78798_e;
        this.field_78795_f = modelRenderer.field_78795_f;
        this.field_78796_g = modelRenderer.field_78796_g;
        this.field_78808_h = modelRenderer.field_78808_h;
        this.field_82906_o = modelRenderer.field_82906_o;
        this.field_82908_p = modelRenderer.field_82908_p;
        this.field_82907_q = modelRenderer.field_82907_q;
        this.scaleX = modelRenderer.scaleX;
        this.scaleY = modelRenderer.scaleY;
        this.scaleZ = modelRenderer.scaleZ;
        this.defaultOffsetX = modelRenderer.defaultOffsetX;
        this.defaultOffsetY = modelRenderer.defaultOffsetY;
        this.defaultOffsetZ = modelRenderer.defaultOffsetZ;
        this.defaultPositionX = modelRenderer.defaultPositionX;
        this.defaultPositionY = modelRenderer.defaultPositionY;
        this.defaultPositionZ = modelRenderer.defaultPositionZ;
        this.defaultRotationX = modelRenderer.defaultRotationX;
        this.defaultRotationY = modelRenderer.defaultRotationY;
        this.defaultRotationZ = modelRenderer.defaultRotationZ;
        this.field_78799_b = modelRenderer.field_78799_b;
        this.field_78801_a = modelRenderer.field_78801_a;
        this.field_78804_l.addAll(modelRenderer.field_78804_l);
        this.scaleChildren = modelRenderer.scaleChildren;
        this.field_78805_m = modelRenderer.field_78805_m;
    }

    public Vec3d getWorldPos(Entity entity, float delta) {
        Vec3d modelPos = this.getModelPos(this, new Vec3d((double)(this.field_78800_c / 16.0f), (double)(-this.field_78797_d / 16.0f), (double)(-this.field_78798_e / 16.0f)));
        double x = modelPos.field_72450_a;
        double y = modelPos.field_72448_b + 1.5;
        double z = modelPos.field_72449_c;
        Matrix4d entityTranslate = new Matrix4d();
        Matrix4d entityRotate = new Matrix4d();
        float dx = (float)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)delta);
        float dy = (float)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)delta);
        float dz = (float)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)delta);
        entityTranslate.set(new Vector3d((double)dx, (double)dy, (double)dz));
        entityRotate.rotY(-Math.toRadians(entity.field_70177_z));
        Point3d rendererPos = new Point3d(x, y, z);
        entityRotate.transform(rendererPos);
        entityTranslate.transform(rendererPos);
        return new Vec3d(rendererPos.getX(), rendererPos.getY(), rendererPos.getZ());
    }

    public Vec3d getWorldPos(Entity entity) {
        return this.getWorldPos(entity, 0.0f);
    }

    public Vec3d getModelPos(AdvancedRendererModel modelRenderer, Vec3d recurseValue) {
        double x = recurseValue.field_72450_a;
        double y = recurseValue.field_72448_b;
        double z = recurseValue.field_72449_c;
        Point3d rendererPos = new Point3d(x, y, z);
        AdvancedRendererModel parent = modelRenderer.getParent();
        if (parent != null) {
            Matrix4d boxTranslate = new Matrix4d();
            Matrix4d boxRotateX = new Matrix4d();
            Matrix4d boxRotateY = new Matrix4d();
            Matrix4d boxRotateZ = new Matrix4d();
            boxTranslate.set(new Vector3d((double)(parent.field_78800_c / 16.0f), (double)(-parent.field_78797_d / 16.0f), (double)(-parent.field_78798_e / 16.0f)));
            boxRotateX.rotX((double)parent.field_78795_f);
            boxRotateY.rotY((double)(-parent.field_78796_g));
            boxRotateZ.rotZ((double)(-parent.field_78808_h));
            boxRotateX.transform(rendererPos);
            boxRotateY.transform(rendererPos);
            boxRotateZ.transform(rendererPos);
            boxTranslate.transform(rendererPos);
            return this.getModelPos(parent, new Vec3d(rendererPos.getX(), rendererPos.getY(), rendererPos.getZ()));
        }
        return new Vec3d(rendererPos.getX(), rendererPos.getY(), rendererPos.getZ());
    }

    public void setWorldPos(Entity entity, Vec3d pos, float delta) {
        Matrix4d entityTranslate = new Matrix4d();
        Matrix4d entityRotate = new Matrix4d();
        float dx = (float)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)delta);
        float dy = (float)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)delta);
        float dz = (float)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)delta);
        entityTranslate.set(new Vector3d((double)dx, (double)dy, (double)dz));
        entityRotate.rotY(-Math.toRadians(entity.field_70177_z));
        entityTranslate.invert();
        entityRotate.invert();
        Point3d rendererPos = new Point3d(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        entityTranslate.transform(rendererPos);
        entityRotate.transform(rendererPos);
        rendererPos.y -= 1.5;
        rendererPos.scale(16.0);
        this.func_78793_a((float)rendererPos.x, -((float)rendererPos.y), -((float)rendererPos.z));
    }
}

