/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.util.network.messages;

import WolfShotz.Wyrmroost.util.ModUtils;
import WolfShotz.Wyrmroost.util.entityutils.client.animation.IAnimatedObject;
import WolfShotz.Wyrmroost.util.network.IMessage;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class AnimationMessage
implements IMessage {
    private int entityID;
    private int animationIndex;

    public AnimationMessage(int entityID, int index) {
        this.entityID = entityID;
        this.animationIndex = index;
    }

    public AnimationMessage(PacketBuffer buf) {
        this.entityID = buf.readInt();
        this.animationIndex = buf.readInt();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.animationIndex);
    }

    @Override
    public void run(Supplier<NetworkEvent.Context> context) {
        World world = (World)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> ModUtils::getClientWorld);
        IAnimatedObject entity = (IAnimatedObject)world.func_73045_a(this.entityID);
        if (this.animationIndex < 0) {
            entity.setAnimation(IAnimatedObject.NO_ANIMATION);
        } else {
            entity.setAnimation(entity.getAnimations()[this.animationIndex]);
        }
    }
}

