/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.tile_entity.TileEntityFunctionalBookcase;
import xerca.xercamod.common.tile_entity.XercaTileEntities;

public class ContainerFunctionalBookcase
extends Container {
    public static List<ResourceLocation> acceptedItems = new ArrayList<ResourceLocation>();
    private TileEntityFunctionalBookcase tileEntity;

    public ContainerFunctionalBookcase(int windowId, PlayerInventory inv, PacketBuffer extraData) {
        this(windowId, inv, inv.field_70458_d.field_70170_p.func_175625_s(extraData.func_179259_c()));
    }

    public ContainerFunctionalBookcase(int windowId, PlayerInventory invPlayer, TileEntity tileEntityInventoryBookcase) {
        super(XercaTileEntities.CONTAINER_FUNCTIONAL_BOOKCASE, windowId);
        if (!(tileEntityInventoryBookcase instanceof TileEntityFunctionalBookcase)) {
            XercaMod.LOGGER.error("TileEntity not an instance of TileEntityFunctionalBookcase!");
            return;
        }
        this.tileEntity = (TileEntityFunctionalBookcase)tileEntityInventoryBookcase;
        IItemHandler bookcaseInventory = (IItemHandler)tileEntityInventoryBookcase.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(NullPointerException::new);
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int TE_INVENTORY_SLOT_COUNT = 6;
        if (6 != bookcaseInventory.getSlots()) {
            XercaMod.LOGGER.error("Mismatched slot count in ContainerFunctionalBookcase(6) and TileEntityFunctionalBookcase (" + bookcaseInventory.getSlots() + ")");
        }
        int TILE_INVENTORY_XPOS = 61;
        int TILE_INVENTORY_YPOS = 17;
        int TILE_SLOT_Y_SPACING = 32;
        int TILE_ROW_COUNT = 2;
        int TILE_COLUMN_COUNT = 3;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 3; ++x) {
                int slotNumber = y * 3 + x;
                int xpos = 61 + x * 18;
                int ypos = 17 + y * 32;
                this.func_75146_a((Slot)new SlotBook(bookcaseInventory, slotNumber, xpos, ypos));
            }
        }
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 142;
        int HOTBAR_SLOT_COUNT = 9;
        for (int x = 0; x < HOTBAR_SLOT_COUNT; ++x) {
            this.func_75146_a(new Slot((IInventory)invPlayer, x, 8 + 18 * x, 142));
        }
        int PLAYER_INVENTORY_XPOS = 8;
        int PLAYER_INVENTORY_YPOS = 84;
        int PLAYER_INVENTORY_ROW_COUNT = 3;
        int PLAYER_INVENTORY_COLUMN_COUNT = 9;
        for (int y = 0; y < PLAYER_INVENTORY_ROW_COUNT; ++y) {
            for (int x = 0; x < PLAYER_INVENTORY_COLUMN_COUNT; ++x) {
                int slotNumber = HOTBAR_SLOT_COUNT + y * PLAYER_INVENTORY_COLUMN_COUNT + x;
                int xpos = 8 + x * 18;
                int ypos = 84 + y * 18;
                this.func_75146_a(new Slot((IInventory)invPlayer, slotNumber, xpos, ypos));
            }
        }
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return this.tileEntity.isUsableByPlayer(player);
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int sourceSlotIndex) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (sourceSlotIndex < containerSlots ? !this.func_75135_a(itemstack1, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.tileEntity.closeInventory(playerIn);
    }

    class SlotBook
    extends SlotItemHandler {
        SlotBook(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            Item it = stack.func_77973_b();
            return it == Items.field_151122_aG || it == Items.field_151099_bA || it == Items.field_151164_bB || it == Items.field_151134_bR || acceptedItems.contains(it.getRegistryName());
        }

        public void func_75218_e() {
            ContainerFunctionalBookcase.this.tileEntity.func_70296_d();
        }
    }
}

