/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xerca.xercamod.common.tile_entity.TileEntityFunctionalBookcase;

public class BlockFunctionalBookcase
extends Block {
    public static final IntegerProperty BOOK_AMOUNT = IntegerProperty.func_177719_a((String)"books", (int)0, (int)6);

    public BlockFunctionalBookcase() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BOOK_AMOUNT, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("block_bookcase");
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileEntityFunctionalBookcase();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player instanceof ServerPlayerEntity) {
            TileEntityFunctionalBookcase tileEntity = (TileEntityFunctionalBookcase)worldIn.func_175625_s(pos);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tent = worldIn.func_175625_s(pos);
            IItemHandler inventory = (IItemHandler)tent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(NullPointerException::new);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i).func_190926_b()) continue;
                ItemEntity item = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, inventory.getStackInSlot(i));
                float multiplier = 0.1f;
                float motionX = worldIn.field_73012_v.nextFloat() - 0.5f;
                float motionY = worldIn.field_73012_v.nextFloat() - 0.5f;
                float motionZ = worldIn.field_73012_v.nextFloat() - 0.5f;
                item.func_213293_j((double)(motionX * multiplier), (double)(motionY * multiplier), (double)(motionZ * multiplier));
                worldIn.func_217376_c((Entity)item);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BOOK_AMOUNT});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (int)(15.0f * ((float)((Integer)blockState.func_177229_b((IProperty)BOOK_AMOUNT)).intValue() / 6.0f));
    }
}

