/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.SoundEvents;
import xerca.xercamod.common.item.ItemTeapot;
import xerca.xercamod.common.item.Items;

public class BlockTeapot
extends Block {
    public static final IntegerProperty TEA_AMOUNT = IntegerProperty.func_177719_a((String)"tea", (int)0, (int)7);
    private static final VoxelShape centerShape = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape topShape = Block.func_208617_a((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0);
    private static final VoxelShape handleShape = Block.func_208617_a((double)7.0, (double)3.0, (double)12.0, (double)9.0, (double)9.0, (double)14.0);
    private static final VoxelShape tipShape = Block.func_208617_a((double)7.0, (double)8.0, (double)3.0, (double)9.0, (double)9.0, (double)4.0);
    private static final VoxelShape shape = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)centerShape, (VoxelShape)topShape), (VoxelShape)handleShape), (VoxelShape)tipShape);

    public BlockTeapot() {
        super(Block.Properties.func_200945_a((Material)Material.field_151571_B).func_200948_a(0.0f, 1.0f).func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)TEA_AMOUNT, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("block_teapot");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random r) {
        int teaAmount = (Integer)stateIn.func_177229_b((IProperty)TEA_AMOUNT);
        if (teaAmount > 0 && r.nextDouble() * 5.0 < (double)teaAmount * 0.5) {
            for (int i = 0; i < r.nextInt(1) + 1; ++i) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_218417_ae, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.6 + r.nextDouble() * 0.5, (double)pos.func_177952_p() + 0.25, 0.0, 0.025, 0.0);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player instanceof ServerPlayerEntity && player.func_184614_ca().func_77973_b() == Items.ITEM_TEACUP && (Integer)state.func_177229_b((IProperty)TEA_AMOUNT) > 0) {
            worldIn.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.TEA_POUR, SoundCategory.PLAYERS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            player.func_184614_ca().func_190918_g(1);
            player.func_191521_c(new ItemStack((IItemProvider)Items.ITEM_FULL_TEACUP_0));
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)TEA_AMOUNT, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)TEA_AMOUNT) - 1)));
        }
        return ActionResultType.SUCCESS;
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        int teaAmount = (Integer)state.func_177229_b((IProperty)TEA_AMOUNT);
        ItemStack teapotStack = teaAmount == 0 ? new ItemStack((IItemProvider)Items.ITEM_TEAPOT) : new ItemStack((IItemProvider)this.getItemHotTeapot(teaAmount));
        return Collections.singletonList(teapotStack);
    }

    public boolean func_196260_a(BlockState blockState, IWorldReader worldReader, BlockPos blockPos) {
        return worldReader.func_180495_p(blockPos.func_177977_b()).func_185904_a().func_76220_a();
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState state1, IWorld world, BlockPos blockPos, BlockPos blockPos1) {
        return direction == Direction.DOWN && !state.func_196955_c((IWorldReader)world, blockPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, direction, state1, world, blockPos, blockPos1);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return shape;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TEA_AMOUNT});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public ItemTeapot getItemHotTeapot(int teaAmount) {
        switch (teaAmount) {
            case 1: {
                return Items.ITEM_HOT_TEAPOT_1;
            }
            case 2: {
                return Items.ITEM_HOT_TEAPOT_2;
            }
            case 3: {
                return Items.ITEM_HOT_TEAPOT_3;
            }
            case 4: {
                return Items.ITEM_HOT_TEAPOT_4;
            }
            case 5: {
                return Items.ITEM_HOT_TEAPOT_5;
            }
            case 6: {
                return Items.ITEM_HOT_TEAPOT_6;
            }
            case 7: {
                return Items.ITEM_HOT_TEAPOT_7;
            }
        }
        return Items.ITEM_HOT_TEAPOT_1;
    }
}

