/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.crafting;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeConditionShapeless
extends ShapelessRecipe {
    private final Supplier<Boolean> condition;
    private IRecipeSerializer serializer;

    public RecipeConditionShapeless(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn, Supplier<Boolean> condition) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
        this.condition = condition;
    }

    public RecipeConditionShapeless(ShapelessRecipe shapedRecipe, Supplier<Boolean> condition, IRecipeSerializer serializer) {
        super(shapedRecipe.func_199560_c(), shapedRecipe.func_193358_e(), shapedRecipe.func_77571_b(), shapedRecipe.func_192400_c());
        this.condition = condition;
        this.serializer = serializer;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (!this.condition.get().booleanValue()) {
            return false;
        }
        return super.func_77569_a(inv, worldIn);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        if (!this.condition.get().booleanValue()) {
            return ItemStack.field_190927_a;
        }
        return super.func_77572_b(inv);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer;
    }

    public void setSerializer(IRecipeSerializer<?> serializer) {
        this.serializer = serializer;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeConditionShapeless> {
        private static final ShapelessRecipe.Serializer shapelessSerializer = new ShapelessRecipe.Serializer();
        private final Supplier<Boolean> condition;

        public Serializer(Supplier<Boolean> condition) {
            this.condition = condition;
        }

        public RecipeConditionShapeless read(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe shapelessRecipe = shapelessSerializer.func_199425_a_(recipeId, json);
            return new RecipeConditionShapeless(shapelessRecipe, this.condition, this);
        }

        public RecipeConditionShapeless read(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapelessRecipe shapelessRecipe = shapelessSerializer.func_199426_a_(recipeId, buffer);
            return new RecipeConditionShapeless(shapelessRecipe, this.condition, this);
        }

        public void write(PacketBuffer buffer, RecipeConditionShapeless recipe) {
            shapelessSerializer.func_199427_a_(buffer, (ShapelessRecipe)recipe);
        }
    }
}

