/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.crafting;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.item.ItemTeapot;
import xerca.xercamod.common.item.Items;

public class RecipeTeaPouring
extends SpecialRecipe {
    public RecipeTeaPouring(ResourceLocation p_i48170_1_) {
        super(p_i48170_1_);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        if (!Config.isTeaEnabled()) {
            return false;
        }
        int i = 0;
        ItemStack teapotStack = ItemStack.field_190927_a;
        ItemTeapot teapot = null;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() instanceof ItemTeapot) {
                if (!teapotStack.func_190926_b()) {
                    return false;
                }
                teapotStack = itemstack;
                teapot = (ItemTeapot)itemstack.func_77973_b();
                if (teapot.isHot()) continue;
                return false;
            }
            if (itemstack.func_77973_b() != Items.ITEM_TEACUP || i > 6) {
                return false;
            }
            ++i;
        }
        return !teapotStack.func_190926_b() && teapot != null && i > 0 && teapot.isHot() && teapot.getTeaAmount() - i >= 0;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        if (!Config.isTeaEnabled()) {
            return ItemStack.field_190927_a;
        }
        int i = 0;
        ItemStack teapotStack = ItemStack.field_190927_a;
        ItemTeapot teapot = null;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() instanceof ItemTeapot) {
                if (!teapotStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                teapotStack = itemstack;
                teapot = (ItemTeapot)itemstack.func_77973_b();
                if (teapot.isHot()) continue;
                return ItemStack.field_190927_a;
            }
            if (itemstack.func_77973_b() != Items.ITEM_TEACUP || i > 6) {
                return ItemStack.field_190927_a;
            }
            ++i;
        }
        if (!teapotStack.func_190926_b() && i >= 1 && teapot != null && teapot.getTeaAmount() - i >= 0) {
            return new ItemStack((IItemProvider)Items.ITEM_FULL_TEACUP_0, i);
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        ItemStack itemstack;
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        int teacupCount = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b() || itemstack.func_77973_b() != Items.ITEM_TEACUP || teacupCount > 6) continue;
            ++teacupCount;
        }
        for (int i = 0; i < nonnulllist.size(); ++i) {
            itemstack = inv.func_70301_a(i);
            if (itemstack.hasContainerItem()) {
                nonnulllist.set(i, (Object)itemstack.getContainerItem());
                continue;
            }
            if (!(itemstack.func_77973_b() instanceof ItemTeapot)) continue;
            ItemTeapot oldTeapot = (ItemTeapot)itemstack.func_77973_b();
            if (oldTeapot.getTeaAmount() > teacupCount) {
                String str = oldTeapot.getRegistryName().toString();
                ItemStack remainingStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)(str = str.substring(0, str.length() - 1) + (oldTeapot.getTeaAmount() - teacupCount)))));
                if (remainingStack.func_190926_b()) break;
                nonnulllist.set(i, (Object)remainingStack);
                break;
            }
            nonnulllist.set(i, (Object)new ItemStack((IItemProvider)Items.ITEM_TEAPOT));
            break;
        }
        return nonnulllist;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Items.CRAFTING_SPECIAL_TEA_POURING;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }
}

