/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.entity;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import xerca.xercamod.common.HookReturningEvent;
import xerca.xercamod.common.SoundEvents;
import xerca.xercamod.common.entity.Entities;
import xerca.xercamod.common.item.Items;

public class EntityHook
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> cau_ent = EntityDataManager.func_187226_a(EntityHook.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final double DEFAULT_SPEED = 1.5;
    private int xTile;
    private int yTile;
    private int zTile;
    private int age = 0;
    private boolean inGround;
    private PlayerEntity angler;
    private int ticksInAir;
    public Entity caughtEntity;
    public boolean isReturning;
    public boolean hasGrappling = false;
    public int turboLevel = 0;
    public boolean hasGentle = false;
    private double speed;
    private ItemStack rod = ItemStack.field_190927_a;

    public EntityHook(EntityType<? extends EntityHook> type, World world) {
        super(type, world);
    }

    public EntityHook(World worldIn) {
        super(Entities.HOOK, worldIn);
        this.xTile = -1;
        this.yTile = -1;
        this.zTile = -1;
        this.field_70158_ak = true;
        this.isReturning = false;
    }

    public EntityHook(World worldIn, PlayerEntity hooker, ItemStack rod, float pullAmount) {
        this(worldIn);
        this.isReturning = false;
        this.angler = hooker;
        if (rod.func_77973_b() == Items.ITEM_GRAB_HOOK) {
            this.rod = rod;
            this.rod.func_196082_o().func_74757_a("cast", true);
            this.hasGrappling = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GRAPPLING, (ItemStack)this.rod) > 0;
            this.hasGentle = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GENTLE_GRAB, (ItemStack)this.rod) > 0;
            this.turboLevel = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_TURBO_GRAB, (ItemStack)this.rod);
        }
        double speedMultiplier = (double)this.turboLevel * 0.25 + 1.0;
        this.speed = 1.5 * speedMultiplier * (double)pullAmount;
        float pitch = this.angler.field_70125_A;
        float yaw = this.angler.field_70177_z;
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        double x = this.angler.func_226277_ct_();
        double y = this.angler.func_226278_cu_() + (double)this.angler.func_70047_e();
        double z = this.angler.func_226281_cx_();
        this.func_70012_b(x, y, z, yaw, pitch);
        Vec3d vec3d = new Vec3d((double)(-f3), (double)(-(f5 / f4)), (double)(-f2));
        double length = vec3d.func_72433_c();
        vec3d = vec3d.func_186678_a(this.speed / length);
        this.func_213317_d(vec3d);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)MathHelper.func_76133_a((double)this.func_195048_a(vec3d))) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public EntityHook(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(world);
    }

    public PlayerEntity getAngler() {
        return this.angler;
    }

    public void func_184206_a(DataParameter<?> key) {
        int i;
        if (cau_ent.equals(key) && (i = ((Integer)this.func_184212_Q().func_187225_a(cau_ent)).intValue()) > 0 && this.caughtEntity != null) {
            this.caughtEntity = null;
        }
        super.func_184206_a(key);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private boolean checkCollision() {
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213856_1_ -> !(p_213856_1_.func_175149_v() || !p_213856_1_.func_70067_L() && !(p_213856_1_ instanceof ItemEntity) || p_213856_1_ == this.angler && this.ticksInAir < 5), (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER, (boolean)true);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity caught = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                if (!(caught instanceof LivingEntity) || caught.equals((Object)this.angler)) {
                    return false;
                }
                this.caughtEntity = caught;
                this.func_184212_Q().func_187227_b(cau_ent, (Object)(this.caughtEntity.func_145782_y() + 1));
                this.caughtEntity = caught;
                if (!this.hasGentle) {
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.HOOK_IMPACT, SoundCategory.PLAYERS, 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.2f + 0.9f);
                    this.caughtEntity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.angler), 3.0f);
                    if (!this.caughtEntity.func_70089_S()) {
                        this.func_70106_y();
                        return true;
                    }
                } else {
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.HOOK_IMPACT, SoundCategory.PLAYERS, 0.6f, this.field_70170_p.field_73012_v.nextFloat() * 0.2f + 1.5f);
                }
                this.caughtEntity.field_70145_X = true;
                this.caughtEntity.func_184210_p();
                return true;
            }
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                this.inGround = true;
                if (this.hasGrappling) {
                    this.func_213293_j(0.0, 0.0, 0.0);
                    this.angler.field_70145_X = true;
                    this.angler.func_184210_p();
                }
                return true;
            }
        }
        return false;
    }

    private void pullEntity() {
        if (this.caughtEntity.func_70089_S()) {
            Vec3d v2;
            Vec3d v1 = this.angler.func_174791_d();
            Vec3d v = v1.func_178788_d(v2 = this.caughtEntity.func_174791_d());
            if (!(v.func_72433_c() > 2.0)) {
                this.func_70106_y();
                return;
            }
            v = v.func_72432_b().func_186678_a(this.speed);
            this.caughtEntity.func_213317_d(v);
            this.caughtEntity.field_70133_I = true;
            this.caughtEntity.field_70160_al = true;
            double height = (double)this.caughtEntity.func_213302_cg() + 0.5;
            this.func_70107_b(this.caughtEntity.func_226277_ct_(), this.caughtEntity.func_174813_aQ().field_72338_b + height * 0.8, this.caughtEntity.func_226281_cx_());
            return;
        }
        this.caughtEntity = null;
    }

    private void pullUser() {
        Vec3d v1 = this.angler.func_174791_d();
        Vec3d v2 = this.func_174791_d();
        Vec3d v = v2.func_178788_d(v1);
        if (v.func_72433_c() > 2.0) {
            v = v.func_72432_b().func_186678_a(this.speed);
            this.angler.func_213317_d(v);
            this.angler.field_70145_X = true;
            this.angler.field_70160_al = true;
            this.angler.field_70133_I = true;
        } else {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(cau_ent, (Object)0);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.angler == null) {
                this.func_70106_y();
                return;
            }
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
        ++this.age;
        if (this.field_70170_p.field_72995_K) {
            int i = (Integer)this.func_184212_Q().func_187225_a(cau_ent);
            if (i > 0 && this.caughtEntity == null) {
                this.caughtEntity = this.field_70170_p.func_73045_a(i - 1);
                MinecraftForge.EVENT_BUS.post((Event)new HookReturningEvent(this));
            }
        } else {
            ItemStack itemstack = this.angler.func_184614_ca();
            if (this.age > 80 || !this.angler.func_70089_S() || itemstack.func_77973_b() != Items.ITEM_GRAB_HOOK || this.func_70068_e((Entity)this.angler) > 4096.0) {
                this.func_70106_y();
                this.angler.field_71104_cf = null;
                return;
            }
        }
        if (this.caughtEntity != null) {
            this.pullEntity();
            return;
        }
        if (this.inGround) {
            if (this.hasGrappling) {
                this.pullUser();
            } else {
                this.func_70106_y();
            }
            return;
        }
        ++this.ticksInAir;
        if (this.ticksInAir == 20) {
            this.setReturning();
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean caughtSomething = this.checkCollision();
            if (caughtSomething) {
                return;
            }
            if (this.isReturning) {
                Vec3d target = this.angler.func_174791_d().func_72441_c(0.0, (double)this.angler.func_70047_e(), 0.0);
                Vec3d v = target.func_178788_d(this.func_174791_d());
                if (v.func_72433_c() < 3.0) {
                    this.func_70106_y();
                    return;
                }
                v = v.func_72432_b().func_186678_a(this.speed).func_178786_a(0.0, 0.1, 0.0);
                this.func_213317_d(v);
            }
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    private void setReturning() {
        this.isReturning = true;
        MinecraftForge.EVENT_BUS.post((Event)new HookReturningEvent(this));
    }

    public void func_213281_b(CompoundNBT tagCompound) {
        tagCompound.func_74768_a("xTile", this.xTile);
        tagCompound.func_74768_a("yTile", this.yTile);
        tagCompound.func_74768_a("zTile", this.zTile);
        tagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
    }

    public void func_70037_a(CompoundNBT tagCompund) {
        this.xTile = tagCompund.func_74762_e("xTile");
        this.yTile = tagCompund.func_74762_e("yTile");
        this.zTile = tagCompund.func_74762_e("zTile");
        this.inGround = tagCompund.func_74771_c("inGround") == 1;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.caughtEntity != null) {
            this.caughtEntity.field_70145_X = false;
        }
        if (this.angler != null) {
            this.angler.field_71104_cf = null;
            this.angler.field_70145_X = false;
        }
        if (this.rod.func_77973_b() == Items.ITEM_GRAB_HOOK) {
            this.rod.func_196082_o().func_74757_a("cast", false);
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.angler != null ? this.angler.func_145782_y() : -1);
        buffer.writeDouble(this.speed);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        int id = additionalData.readInt();
        Entity ent = this.field_70170_p.func_73045_a(id);
        if (ent instanceof PlayerEntity) {
            this.angler = (PlayerEntity)ent;
        }
        this.speed = additionalData.readDouble();
    }
}

