/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.HammerAttackPacket;
import xerca.xercamod.common.packets.HammerQuakePacket;

public class ItemWarhammer
extends Item {
    private final float weaponDamage;
    private final float pushAmount;
    private final ItemTier material;

    public ItemWarhammer(String name, ItemTier mat) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78037_j).func_200917_a(1).func_200915_b(mat.func_200926_a()));
        this.setRegistryName(name);
        this.material = mat;
        this.weaponDamage = 1.0f + mat.func_200929_c();
        this.pushAmount = this.getPushFromMaterial(mat);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(@Nonnull ItemStack stack, World worldIn, LivingEntity entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack.func_77973_b() instanceof ItemWarhammer ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / (ItemWarhammer.this.getFullUseSeconds(stack) * 20.0f) : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(@Nonnull ItemStack stack, World worldIn, LivingEntity entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    private float getPushFromMaterial(ItemTier mat) {
        float push = mat == ItemTier.STONE ? 0.15f : (mat == ItemTier.IRON ? 0.3f : (mat == ItemTier.DIAMOND ? 0.4f : 0.5f));
        return push;
    }

    public int func_77619_b() {
        return this.material.func_200927_e();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.BREAKABLE || enchantment == Items.ENCHANTMENT_HEAVY || enchantment == Items.ENCHANTMENT_QUAKE || enchantment == Items.ENCHANTMENT_MAIM || enchantment == Items.ENCHANTMENT_QUICK || enchantment == Items.ENCHANTMENT_UPPERCUT || enchantment == Enchantments.field_185303_l || enchantment == Enchantments.field_180312_n || enchantment == Enchantments.field_185304_p;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, p -> p.func_213334_d(Hand.MAIN_HAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState blockIn, BlockPos pos, LivingEntity entityLiving) {
        if ((double)blockIn.func_185887_b((IBlockReader)worldIn, pos) != 0.0) {
            stack.func_222118_a(1, entityLiving, p -> p.func_213334_d(Hand.MAIN_HAND));
        }
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return blockIn.func_177230_c() == Blocks.field_150348_b;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        Ingredient ingr = this.material.func_200924_f();
        if (ingr.test(repair)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponDamage, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.0, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public float getFullUseSeconds(ItemStack stack) {
        float seconds = 1.0f;
        if (stack.func_77948_v()) {
            int heavyLevel = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_HEAVY, (ItemStack)stack);
            if (heavyLevel > 0) {
                float multiplier = 0.1f * (float)heavyLevel;
                seconds += seconds * multiplier;
            } else {
                int quickLevel = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_QUICK, (ItemStack)stack);
                float multiplier = 0.12f * (float)quickLevel;
                seconds -= seconds * multiplier;
            }
        }
        return seconds;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        playerIn.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        float useSeconds = (float)(this.func_77626_a(stack) - timeLeft) / 20.0f;
        float f = useSeconds / this.getFullUseSeconds(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        if ((double)f >= 0.1) {
            player.func_184609_a(Hand.MAIN_HAND);
            if (worldIn.field_72995_K) {
                Minecraft mine = Minecraft.func_71410_x();
                if (mine.field_71476_x != null) {
                    if (mine.field_71476_x.func_216346_c() == RayTraceResult.Type.ENTITY) {
                        Entity target = ((EntityRayTraceResult)mine.field_71476_x).func_216348_a();
                        HammerAttackPacket pack = new HammerAttackPacket(f, target.func_145782_y());
                        XercaMod.NETWORK_HANDLER.sendToServer((Object)pack);
                    } else if (mine.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK && EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_QUAKE, (ItemStack)stack) > 0) {
                        HammerQuakePacket pack = new HammerQuakePacket(mine.field_71476_x.func_216347_e(), f);
                        XercaMod.NETWORK_HANDLER.sendToServer((Object)pack);
                    }
                }
            }
        }
    }

    public float getPushAmount() {
        return this.pushAmount;
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!Config.isWarhammerEnabled()) {
            return;
        }
        super.func_150895_a(group, items);
    }
}

