/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercamod.common.SoundEvents;
import xerca.xercamod.common.item.ItemWarhammer;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.HammerAttackPacket;

public class HammerAttackPacketHandler {
    public static void handle(HammerAttackPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when HammerAttackPacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> HammerAttackPacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    static float damageBonusMult(float pullDuration) {
        if (pullDuration >= 0.95f) {
            return 1.75f;
        }
        if (pullDuration >= 0.7f) {
            return 1.0f;
        }
        if (pullDuration >= 0.4f) {
            return 0.75f;
        }
        return 0.5f;
    }

    private static void processMessage(HammerAttackPacket msg, ServerPlayerEntity pl) {
        Entity target = pl.field_70170_p.func_73045_a(msg.getTargetId());
        ItemStack st = pl.func_184614_ca();
        Item item = st.func_77973_b();
        if (item instanceof ItemWarhammer) {
            float pull = msg.getPullDuration();
            float mult = HammerAttackPacketHandler.damageBonusMult(pull);
            int heavyLevel = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_HEAVY, (ItemStack)st);
            float damage = ((float)pl.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + (float)heavyLevel * 0.5f) * mult;
            float push = (((ItemWarhammer)item).getPushAmount() + (float)heavyLevel * 0.15f) * 2.0f * mult;
            int uppercutLevel = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_UPPERCUT, (ItemStack)st);
            double bonusVelY = (double)uppercutLevel * 0.25 * (double)pull;
            float pitch = 2.0f / (damage + (float)heavyLevel);
            pl.field_70170_p.func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_() + 0.5, target.func_226281_cx_(), SoundEvents.HAMMER, SoundCategory.PLAYERS, 1.0f, pl.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.4f + pitch);
            st.func_222118_a(1, (LivingEntity)pl, p -> p.func_213334_d(Hand.MAIN_HAND));
            if (target instanceof LivingEntity) {
                LivingEntity targetLiving = (LivingEntity)target;
                float enchantBonus = EnchantmentHelper.func_152377_a((ItemStack)st, (CreatureAttribute)targetLiving.func_70668_bt());
                targetLiving.func_70097_a(DamageSource.func_76365_a((PlayerEntity)pl), damage += enchantBonus);
                int maimLevel = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_MAIM, (ItemStack)st);
                if (maimLevel > 0) {
                    targetLiving.func_195064_c(new EffectInstance(Effects.field_76421_d, 100 + 40 * maimLevel, maimLevel - 1));
                }
            }
            Vec3d knockVector = target.func_174791_d().func_178788_d(pl.func_174791_d()).func_72432_b().func_186678_a((double)push);
            target.func_70024_g(knockVector.field_72450_a, knockVector.field_72448_b + bonusVelY, knockVector.field_72449_c);
            target.field_70133_I = true;
        } else {
            System.out.println("No warhammer at hand!");
        }
    }
}

