/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import xerca.xercamod.common.SoundEvents;
import xerca.xercamod.common.Triggers;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.ItemScythe;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.BeheadParticlePacket;
import xerca.xercamod.common.packets.ScytheAttackPacket;

public class ScytheAttackPacketHandler {
    public static void handle(ScytheAttackPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when ScytheAttackPacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> ScytheAttackPacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(ScytheAttackPacket msg, ServerPlayerEntity pl) {
        ItemStack st = pl.func_184614_ca();
        Item item = st.func_77973_b();
        if (item instanceof ItemScythe && EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)st) > 0) {
            float pull = msg.getPullDuration();
            if (pull < 0.9f) {
                XercaMod.LOGGER.warn("Pull duration too short");
                return;
            }
            Entity target = pl.field_70170_p.func_73045_a(msg.getTargetId());
            float damage = (float)pl.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 1.3f;
            st.func_222118_a(1, (LivingEntity)pl, p -> p.func_213334_d(Hand.MAIN_HAND));
            if (target instanceof LivingEntity) {
                LivingEntity targetLiving = (LivingEntity)target;
                float enchantBonus = EnchantmentHelper.func_152377_a((ItemStack)st, (CreatureAttribute)targetLiving.func_70668_bt());
                targetLiving.func_70097_a(DamageSource.func_76365_a((PlayerEntity)pl), damage += enchantBonus);
                if (targetLiving.func_110143_aJ() <= 0.0f) {
                    pl.field_70170_p.func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_() + 0.5, target.func_226281_cx_(), SoundEvents.BEHEAD, SoundCategory.PLAYERS, 1.0f, pl.field_70170_p.field_73012_v.nextFloat() * 0.2f + 0.9f);
                    BeheadParticlePacket pack = new BeheadParticlePacket(96, targetLiving.func_226277_ct_(), targetLiving.func_226278_cu_(), targetLiving.func_226281_cx_());
                    XercaMod.NETWORK_HANDLER.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(targetLiving.func_226277_ct_(), targetLiving.func_226278_cu_(), targetLiving.func_226281_cx_(), 64.0, pl.field_71093_bK)), (Object)pack);
                    ItemScythe.spawnHead(targetLiving);
                    Triggers.BEHEAD.trigger(pl);
                } else {
                    pl.field_70170_p.func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_() + 0.5, target.func_226281_cx_(), net.minecraft.util.SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, pl.field_70170_p.field_73012_v.nextFloat() * 0.2f + 0.9f);
                }
            }
        } else {
            XercaMod.LOGGER.warn("No Scythe at hand or doesn't have guillotine!");
        }
    }
}

