/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.crafting;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeConditionShaped
extends ShapedRecipe {
    private final Supplier<Boolean> condition;
    private IRecipeSerializer serializer;

    public RecipeConditionShaped(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, Supplier<Boolean> condition) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.condition = condition;
    }

    public RecipeConditionShaped(ShapedRecipe shapedRecipe, Supplier<Boolean> condition, IRecipeSerializer serializer) {
        super(shapedRecipe.func_199560_c(), shapedRecipe.func_193358_e(), shapedRecipe.getRecipeWidth(), shapedRecipe.getRecipeHeight(), shapedRecipe.func_192400_c(), shapedRecipe.func_77571_b());
        this.condition = condition;
        this.serializer = serializer;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (!this.condition.get().booleanValue()) {
            return false;
        }
        return super.func_77569_a(inv, worldIn);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        if (!this.condition.get().booleanValue()) {
            return ItemStack.field_190927_a;
        }
        return super.func_77572_b(inv);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer;
    }

    public void setSerializer(IRecipeSerializer<?> serializer) {
        this.serializer = serializer;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeConditionShaped> {
        private static final ShapedRecipe.Serializer shapedSerializer = new ShapedRecipe.Serializer();
        private final Supplier<Boolean> condition;

        public Serializer(Supplier<Boolean> condition) {
            this.condition = condition;
        }

        public RecipeConditionShaped read(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe shapedRecipe = shapedSerializer.func_199425_a_(recipeId, json);
            return new RecipeConditionShaped(shapedRecipe, this.condition, this);
        }

        public RecipeConditionShaped read(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapedRecipe shapedRecipe = shapedSerializer.func_199426_a_(recipeId, buffer);
            return new RecipeConditionShaped(shapedRecipe, this.condition, this);
        }

        public void write(PacketBuffer buffer, RecipeConditionShaped recipe) {
            shapedSerializer.func_199427_a_(buffer, (ShapedRecipe)recipe);
        }
    }
}

