/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.crafting;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.item.ItemFlask;

public class RecipeFlaskFilling
extends SpecialRecipe {
    public RecipeFlaskFilling(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        if (!Config.isEnderFlaskEnabled()) {
            return false;
        }
        int i = 0;
        Potion potionType = Potions.field_185229_a;
        ItemStack flaskStack = ItemStack.field_190927_a;
        Potion currentFlaskPotion = Potions.field_185229_a;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() == xerca.xercamod.common.item.Items.FLASK) {
                if (!flaskStack.func_190926_b()) {
                    return false;
                }
                flaskStack = itemstack;
                currentFlaskPotion = PotionUtils.func_185191_c((ItemStack)flaskStack);
                if (potionType == Potions.field_185229_a || currentFlaskPotion.equals(Potions.field_185229_a) || currentFlaskPotion.equals(potionType)) continue;
                return false;
            }
            if (!(itemstack.func_77973_b() instanceof PotionItem)) {
                return false;
            }
            if (potionType.equals(Potions.field_185229_a)) {
                potionType = PotionUtils.func_185191_c((ItemStack)itemstack);
            } else if (!PotionUtils.func_185191_c((ItemStack)itemstack).equals(potionType)) {
                return false;
            }
            if (!currentFlaskPotion.equals(Potions.field_185229_a) && !currentFlaskPotion.equals(potionType)) {
                return false;
            }
            ++i;
        }
        return !flaskStack.func_190926_b() && i > 0 && !potionType.equals(Potions.field_185229_a) && ItemFlask.getCharges(flaskStack) + i <= ItemFlask.getMaxCharges(flaskStack);
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        if (!Config.isEnderFlaskEnabled()) {
            return ItemStack.field_190927_a;
        }
        int i = 0;
        Potion potionType = Potions.field_185229_a;
        ItemStack flaskStack = ItemStack.field_190927_a;
        Potion currentFlaskPotion = Potions.field_185229_a;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() == xerca.xercamod.common.item.Items.FLASK) {
                if (!flaskStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                flaskStack = itemstack;
                currentFlaskPotion = PotionUtils.func_185191_c((ItemStack)flaskStack);
                if (potionType == Potions.field_185229_a || currentFlaskPotion.equals(Potions.field_185229_a) || currentFlaskPotion.equals(potionType)) continue;
                return ItemStack.field_190927_a;
            }
            if (!(itemstack.func_77973_b() instanceof PotionItem)) {
                return ItemStack.field_190927_a;
            }
            if (potionType.equals(Potions.field_185229_a)) {
                potionType = PotionUtils.func_185191_c((ItemStack)itemstack);
            } else if (!PotionUtils.func_185191_c((ItemStack)itemstack).equals(potionType)) {
                return ItemStack.field_190927_a;
            }
            if (!currentFlaskPotion.equals(Potions.field_185229_a) && !currentFlaskPotion.equals(potionType)) {
                return ItemStack.field_190927_a;
            }
            ++i;
        }
        int oldCharges = ItemFlask.getCharges(flaskStack);
        if (!flaskStack.func_190926_b() && i > 0 && !potionType.equals(Potions.field_185229_a) && oldCharges + i <= ItemFlask.getMaxCharges(flaskStack)) {
            ItemStack resultStack = new ItemStack((IItemProvider)xerca.xercamod.common.item.Items.FLASK);
            resultStack.func_77982_d(flaskStack.func_196082_o().func_74737_b());
            PotionUtils.func_185188_a((ItemStack)resultStack, (Potion)potionType);
            ItemFlask.setCharges(resultStack, oldCharges + i);
            return resultStack;
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.hasContainerItem()) {
                nonnulllist.set(i, (Object)itemstack.getContainerItem());
                continue;
            }
            if (!(itemstack.func_77973_b() instanceof PotionItem)) continue;
            ItemStack bottle = new ItemStack((IItemProvider)Items.field_151069_bo);
            nonnulllist.set(i, (Object)bottle);
        }
        return nonnulllist;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return xerca.xercamod.common.item.Items.CRAFTING_SPECIAL_FLASK_FILLING;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }
}

