/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.item.Items;

public class ItemEnderBow
extends Item {
    public ItemEnderBow() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78038_k).func_200917_a(1).func_200918_c(160));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (ItemEnderBow.getCharges(stack) > 0) {
            float range = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_RANGE, (ItemStack)stack) + 1;
            if (range > 1.0f) {
                range *= 0.8f;
            }
            worldIn.func_184148_a(playerIn, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (!worldIn.field_72995_K) {
                PotionEntity potionentity = new PotionEntity(worldIn, (LivingEntity)playerIn);
                ItemStack potionStack = new ItemStack((IItemProvider)(ItemEnderBow.isLingering(stack) ? net.minecraft.item.Items.field_185156_bI : net.minecraft.item.Items.field_185155_bH));
                PotionUtils.func_185188_a((ItemStack)potionStack, (Potion)PotionUtils.func_185191_c((ItemStack)stack));
                potionentity.func_213884_b(potionStack);
                potionentity.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, -10.0f, 0.5f * range, 1.0f / range);
                worldIn.func_217376_c((Entity)potionentity);
                this.decrementCharges(stack);
                stack.func_222118_a(1, (LivingEntity)playerIn, playerEntity -> playerEntity.func_213334_d(handIn));
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    public static boolean isLingering(ItemStack itemstack) {
        CompoundNBT tag;
        if (itemstack.func_77942_o() && (tag = itemstack.func_77978_p()).func_74764_b("isLinger")) {
            return tag.func_74767_n("isLinger");
        }
        return false;
    }

    public static int getCharges(ItemStack itemstack) {
        CompoundNBT tag;
        if (itemstack.func_77942_o() && (tag = itemstack.func_77978_p()).func_74764_b("charges")) {
            return tag.func_74762_e("charges");
        }
        return 0;
    }

    private boolean decrementCharges(ItemStack itemstack) {
        int oldCharges;
        CompoundNBT tag = itemstack.func_196082_o();
        if (tag.func_74764_b("charges") && (oldCharges = tag.func_74762_e("charges")) > 0) {
            if (oldCharges == 1) {
                tag.func_82580_o("Potion");
            }
            tag.func_74768_a("charges", oldCharges - 1);
            return true;
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        return PotionUtils.func_185191_c((ItemStack)stack).func_185174_b(this.func_77658_a() + ".effect.");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        PotionUtils.func_185182_a((ItemStack)stack, tooltip, (float)1.0f);
        tooltip.add((ITextComponent)new StringTextComponent(ItemEnderBow.getCharges(stack) + " charges").func_240699_a_(TextFormatting.YELLOW));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack);
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!Config.isEnderFlaskEnabled()) {
            return;
        }
        super.func_150895_a(group, items);
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment ench) {
        return ench.field_77351_y == EnchantmentType.BREAKABLE || ench == Items.ENCHANTMENT_RANGE || ench == Items.ENCHANTMENT_CAPACITY;
    }
}

